/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2277", priority=Priority.CRITICAL, tags={"cwe", "owasp-top10", "security"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class RSAUsesOAEPCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL);
    }

    public void visitNode(Tree tree) {
        LiteralTree lt = (LiteralTree)tree;
        if (this.isRSA(LiteralUtils.trimQuotes((String)lt.value()))) {
            this.addIssue((Tree)lt, "Use an RSA algorithm with an OAEP (Optimal Asymmetric Encryption Padding).");
        }
    }

    private boolean isRSA(String algorithmName) {
        return algorithmName.startsWith("RSA/NONE");
    }
}

