/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.AnnotationInstance;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1710", priority=Priority.CRITICAL, tags={"java8"})
public class RepeatAnnotationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1710";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1710");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        NewArrayTree arrayTree;
        if (this.isArrayInitialized(annotationTree) && this.isAllSameAnnotation((arrayTree = (NewArrayTree)annotationTree.arguments().get(0)).initializers()) && this.isAnnotationRepeatable((ExpressionTree)arrayTree.initializers().get(0))) {
            this.context.addIssue((Tree)annotationTree, this.ruleKey, "Remove the '" + this.getAnnotationName((ExpressionTree)annotationTree) + "' wrapper from this annotation group");
        }
        super.visitAnnotation(annotationTree);
    }

    private boolean isAnnotationRepeatable(ExpressionTree expressionTree) {
        List annotations = ((AbstractTypedTree)expressionTree).getSymbolType().getSymbol().metadata().annotations();
        for (AnnotationInstance annotation : annotations) {
            if (!annotation.isTyped("java.lang.annotation.Repeatable")) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSameAnnotation(List<ExpressionTree> initializers) {
        if (initializers.isEmpty()) {
            return false;
        }
        String annotationName = this.getAnnotationName(initializers.get(0));
        if (annotationName.isEmpty()) {
            return false;
        }
        for (int i = 1; i < initializers.size(); ++i) {
            if (annotationName.equals(this.getAnnotationName(initializers.get(i)))) continue;
            return false;
        }
        return true;
    }

    private String getAnnotationName(ExpressionTree initializer) {
        String result = "";
        if (initializer.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            Tree annotationType = ((AnnotationTree)initializer).annotationType();
            if (annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                result = ((IdentifierTree)annotationType).name();
            } else if (annotationType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                result = this.fullName((MemberSelectExpressionTree)annotationType);
            }
        }
        return result;
    }

    private String fullName(MemberSelectExpressionTree tree) {
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree.expression()).name() + "." + tree.identifier().name();
        }
        return this.fullName((MemberSelectExpressionTree)tree.expression()) + "." + tree.identifier().name();
    }

    private boolean isArrayInitialized(AnnotationTree annotationTree) {
        return annotationTree.arguments().size() == 1 && ((ExpressionTree)annotationTree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY});
    }
}

