/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2063", priority=Priority.MAJOR, tags={"pitfall", "serialization"})
public class SerializableComparatorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTreeImpl classTree;
        Symbol.TypeSymbol symbol;
        Type type;
        if (this.hasSemantic() && (type = (symbol = (classTree = (ClassTreeImpl)tree).getSymbol()).getType()).isSubtypeOf("java.util.Comparator") && !type.isSubtypeOf("java.io.Serializable") && !symbol.isAbstract()) {
            this.addIssue((Tree)classTree, "Make this class \"Serializable\".");
        }
    }
}

