/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1948", priority=Priority.MAJOR, tags={"bug", "cwe", "serialization"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SerializableFieldInSerializableClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.isSerializable((Tree)classTree) && !this.hasSpecialHandlingSerializationMethods(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || this.isStatic((VariableTree)member) || this.isTransientOrSerializable((VariableTree)member)) continue;
                this.addIssue(member, "Make \"" + ((VariableTree)member).simpleName().name() + "\" transient or serializable.");
            }
        }
    }

    private boolean isStatic(VariableTree member) {
        return member.modifiers().modifiers().contains(Modifier.STATIC);
    }

    private boolean hasSpecialHandlingSerializationMethods(ClassTree classTree) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        for (Tree member : classTree.members()) {
            MethodTree methodTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !(methodTree = (MethodTree)member).modifiers().modifiers().contains(Modifier.PRIVATE) || methodTree.parameters().size() != 1) continue;
            hasWriteObject |= "writeObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 1;
            hasReadObject |= "readObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 2;
        }
        return hasReadObject && hasWriteObject;
    }

    private boolean isTransientOrSerializable(VariableTree member) {
        return member.modifiers().modifiers().contains(Modifier.TRANSIENT) || this.isSerializable(member.type());
    }

    private boolean isSerializable(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM, Tree.Kind.PRIMITIVE_TYPE})) {
            return true;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol symbol = ((ClassTreeImpl)tree).getSymbol();
            if (symbol == null) {
                return false;
            }
            return this.implementsSerializable(symbol.getType());
        }
        return this.implementsSerializable(((AbstractTypedTree)tree).getSymbolType());
    }

    private boolean implementsSerializable(@Nullable Type type) {
        if (type == null || type.isTagged(14)) {
            return false;
        }
        if (type.isTagged(11)) {
            return this.implementsSerializable(((Type.ArrayType)type).elementType());
        }
        if (type.isTagged(10)) {
            Type.ClassType classType = (Type.ClassType)type;
            String interfaceName = classType.getSymbol().owner().getName() + "." + classType.getSymbol().getName();
            if ("java.io.Serializable".equals(interfaceName)) {
                return true;
            }
            return this.hasSupertypeSerializable((Type.ClassType)type);
        }
        return false;
    }

    private boolean hasSupertypeSerializable(Type.ClassType type) {
        Symbol.TypeSymbol symbol = type.getSymbol();
        for (Type interfaceType : symbol.getInterfaces()) {
            if (!this.implementsSerializable(interfaceType)) continue;
            return true;
        }
        return this.implementsSerializable(symbol.getSuperclass());
    }
}

