/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import org.sonar.java.resolve.Type;

public abstract class TypeCriteria {
    public static TypeCriteria subtypeOf(String fullyQualifiedName) {
        return new SubtypeTypeCriteria(fullyQualifiedName);
    }

    public static TypeCriteria is(String fullyQualifiedName) {
        return new FullyQualifiedNameTypeCriteria(fullyQualifiedName);
    }

    public abstract boolean matches(Type var1);

    private static class SubtypeTypeCriteria
    extends TypeCriteria {
        private String superTypeName;

        public SubtypeTypeCriteria(String superTypeName) {
            this.superTypeName = superTypeName;
        }

        @Override
        public boolean matches(Type type) {
            if (type.is(this.superTypeName)) {
                return true;
            }
            if (type.isTagged(10)) {
                for (Type.ClassType classType : type.getSymbol().superTypes()) {
                    if (!classType.is(this.superTypeName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class FullyQualifiedNameTypeCriteria
    extends TypeCriteria {
        private String fullyQualifiedName;

        public FullyQualifiedNameTypeCriteria(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public boolean matches(Type type) {
            return type.is(this.fullyQualifiedName);
        }
    }
}

