/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1188", name="Lambdas and anonymous classes should not have too many lines", tags={"java8"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="20min")
public class AnonymousClassesTooBigCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="Max", defaultValue="20", description="Maximum allowed lines in an anonymous class/lambda")
    public int max = 20;
    private JavaFileScannerContext context;
    private boolean isEnumConstantBody;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.isEnumConstantBody = false;
        this.scan((Tree)context.getTree());
    }

    public void visitNewClass(NewClassTree tree) {
        int lines;
        if (tree.classBody() != null && !this.isEnumConstantBody && (lines = this.getNumberOfLines(tree.classBody())) > this.max) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Reduce this anonymous class number of lines from " + lines + " to at most " + this.max + ", or make it a named class.");
        }
        this.isEnumConstantBody = false;
        super.visitNewClass(tree);
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.isEnumConstantBody = true;
        super.visitEnumConstant(tree);
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        int lines = this.getNumberOfLines(((JavaTree)lambdaExpressionTree.body()).getAstNode());
        if (lines > this.max) {
            this.context.addIssue((Tree)lambdaExpressionTree, (JavaCheck)this, "Reduce this lambda expression number of lines from " + lines + " to at most " + this.max + ".");
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    private int getNumberOfLines(ClassTree classTree) {
        int startLine = ((InternalSyntaxToken)classTree.openBraceToken()).getLine();
        int endline = ((InternalSyntaxToken)classTree.closeBraceToken()).getLine();
        return endline - startLine + 1;
    }

    private int getNumberOfLines(AstNode node) {
        return node.getLastToken().getLine() - node.getTokenLine() + 1;
    }
}

