/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.TreeFactory;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1195", name="Array designators \"[]\" should be located after the type in method signatures", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayDesignatorAfterTypeCheck
extends SquidCheck<LexerlessGrammar>
implements JavaCheck {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.METHOD});
    }

    public void visitNode(AstNode node) {
        if (node.hasDirectChildren(new AstNodeType[]{TreeFactory.WRAPPER_AST_NODE})) {
            this.getContext().createLineViolation((CodeCheck)this, "Move the array designators \"[]\" to the end of the return type.", node, new Object[0]);
        }
    }
}

