/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2698", name="JUnit assertions should include messages", tags={"junit"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class AssertionsWithoutMessageCheck
extends AbstractMethodDetection {
    private static final String GENERIC_ASSERT = "org.fest.assertions.GenericAssert";
    private static final MethodInvocationMatcher FEST_AS_METHOD = MethodInvocationMatcher.create().typeDefinition("org.fest.assertions.GenericAssert").name("as").addParameter("java.lang.String");
    private static final Set<String> ASSERT_METHODS_WITH_ONE_PARAM = Sets.newHashSet((Object[])new String[]{"assertNull", "assertNotNull"});
    private static final Set<String> ASSERT_METHODS_WITH_TWO_PARAMS = Sets.newHashSet((Object[])new String[]{"assertEquals", "assertSame", "assertNotSame", "assertThat"});

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return Lists.newArrayList((Object[])new MethodInvocationMatcher[]{MethodInvocationMatcher.create().typeDefinition("org.junit.Assert").name(NameCriteria.startsWith("assert")).withNoParameterConstraint(), MethodInvocationMatcher.create().typeDefinition("org.junit.Assert").name("fail").withNoParameterConstraint(), MethodInvocationMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith("assert")).withNoParameterConstraint(), MethodInvocationMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodInvocationMatcher.create().typeDefinition("org.fest.assertions.Fail").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf(GENERIC_ASSERT)).name(NameCriteria.any()).withNoParameterConstraint()});
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        if (mit.symbol().owner().type().isSubtypeOf(GENERIC_ASSERT) && !FEST_AS_METHOD.matches(mit)) {
            FestVisitor visitor = new FestVisitor();
            mit.methodSelect().accept((TreeVisitor)visitor);
            if (!visitor.useDescription) {
                this.addIssue((Tree)mit, "Add a message to this assertion.");
            }
        } else if (mit.arguments().isEmpty() || !this.isString((ExpressionTree)mit.arguments().get(0)) || this.isAssertingOnStringWithNoMessage(mit)) {
            this.addIssue((Tree)mit, "Add a message to this assertion.");
        }
    }

    private boolean isAssertingOnStringWithNoMessage(MethodInvocationTree mit) {
        return this.isAssertWithTwoParams(mit) || this.isAssertWithOneParam(mit);
    }

    private boolean isAssertWithOneParam(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_ONE_PARAM.contains(mit.symbol().name()) && mit.arguments().size() == 1;
    }

    private boolean isAssertWithTwoParams(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_TWO_PARAMS.contains(mit.symbol().name()) && mit.arguments().size() == 2;
    }

    private boolean isString(ExpressionTree expressionTree) {
        return expressionTree.symbolType().is("java.lang.String");
    }

    private static class FestVisitor
    extends BaseTreeVisitor {
        boolean useDescription = false;

        private FestVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.useDescription |= FEST_AS_METHOD.matches(tree);
            super.visitMethodInvocation(tree);
        }
    }
}

