/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2388", name="Inner class calls to super class methods should be unambiguous", tags={"pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CallSuperMethodFromInnerClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (classSymbol != null && this.isInnerClass((Symbol)classSymbol) && !this.extendsOuterClass(classSymbol)) {
            classTree.accept((TreeVisitor)new MethodInvocationVisitor(classSymbol));
        }
    }

    private boolean isInnerClass(Symbol symbol) {
        return symbol.owner().isTypeSymbol();
    }

    private boolean extendsOuterClass(Symbol.TypeSymbol classSymbol) {
        Type superType = classSymbol.superClass();
        return superType != null && superType.equals(classSymbol.owner().type());
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private final Symbol.TypeSymbol classSymbol;

        public MethodInvocationVisitor(Symbol.TypeSymbol classSymbol) {
            this.classSymbol = classSymbol;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol = tree.symbol();
            if (symbol.isMethodSymbol() && tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.isInherited(symbol) && this.outerClassHasMethodWithSameName(symbol)) {
                String methodName = ((IdentifierTree)tree.methodSelect()).name();
                CallSuperMethodFromInnerClassCheck.this.addIssue((Tree)tree, "Prefix this call to \"" + methodName + "\" with \"super.\".");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isInherited(Symbol symbol) {
            Type methodOwnerType = symbol.owner().type();
            Type innerType = this.classSymbol.type();
            return !symbol.isStatic() && innerType.isSubtypeOf(methodOwnerType) && !this.classSymbol.owner().type().equals(methodOwnerType) && !innerType.equals(methodOwnerType);
        }

        private boolean outerClassHasMethodWithSameName(Symbol symbol) {
            return !((Symbol.TypeSymbol)this.classSymbol.owner()).lookupSymbols(symbol.name()).isEmpty();
        }
    }
}

