/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2175", name="Inappropriate \"Collection\" calls should not be made", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class CollectionInappropriateCallsCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)this.collectionMethodInvocation("remove"), (Object)this.collectionMethodInvocation("contains"));
    }

    private MethodInvocationMatcher collectionMethodInvocation(String methodName) {
        return MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.util.Collection")).name(methodName).addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodFound(MethodInvocationTree tree) {
        Type argumentType = this.getType((ExpressionTree)tree.arguments().get(0));
        Type collectionType = this.getMethodOwner(tree);
        Type collectionParameterType = this.getTypeParameter(collectionType);
        if (collectionParameterType != null && !collectionParameterType.isUnknown() && !this.isArgumentCompatible(argumentType, collectionParameterType)) {
            this.addIssue((Tree)tree, MessageFormat.format("A \"{0}<{1}>\" cannot contain a \"{2}\"", collectionType, collectionParameterType, argumentType));
        }
    }

    private Type getType(ExpressionTree tree) {
        return tree.symbolType();
    }

    private Type getMethodOwner(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return this.getType(((MemberSelectExpressionTree)mit.methodSelect()).expression());
        }
        return mit.symbol().owner().type();
    }

    @Nullable
    private Type getTypeParameter(Type collectionType) {
        if (collectionType instanceof JavaType.ParametrizedTypeJavaType) {
            return this.getFirstTypeParameter((JavaType.ParametrizedTypeJavaType)collectionType);
        }
        return null;
    }

    @Nullable
    private Type getFirstTypeParameter(JavaType.ParametrizedTypeJavaType parametrizedTypeType) {
        Iterator i$ = parametrizedTypeType.typeParameters().iterator();
        if (i$.hasNext()) {
            JavaType.TypeVariableJavaType variableType = (JavaType.TypeVariableJavaType)i$.next();
            return parametrizedTypeType.substitution(variableType);
        }
        return null;
    }

    private boolean isArgumentCompatible(Type argumentType, Type collectionParameterType) {
        return this.isSubtypeOf(argumentType.erasure(), collectionParameterType.erasure()) || this.isSubtypeOf(collectionParameterType.erasure(), argumentType.erasure()) || this.autoboxing(argumentType, collectionParameterType);
    }

    private boolean isSubtypeOf(Type type, Type superType) {
        return type.isSubtypeOf(superType);
    }

    private boolean autoboxing(Type argumentType, Type collectionParameterType) {
        return argumentType.isPrimitive() && ((JavaType)collectionParameterType).isPrimitiveWrapper() && this.isSubtypeOf((Type)((JavaType)argumentType).primitiveWrapperType(), collectionParameterType);
    }
}

