/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.JavaFootprint;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.InternalSyntaxTrivia;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.LanguageFootprint;

@Rule(key="CommentedOutCodeLine", name="Sections of code should not be \"commented out\"", tags={"misra", "unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CommentedOutCodeLineCheck
extends SubscriptionBaseVisitor {
    private static final double THRESHOLD = 0.9;
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new JavaFootprint());
    private List<SyntaxTrivia> comments;
    private static final String START_JSNI = "/*-{";
    private static final String END_JSNI = "}-*/";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.comments = Lists.newArrayList();
        super.scanFile(context);
        this.leaveFile();
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        if (!(CommentedOutCodeLineCheck.isHeader(syntaxTrivia) || this.isJavadoc(syntaxTrivia.comment()) || this.isJSNI(syntaxTrivia.comment()))) {
            this.comments.add(syntaxTrivia);
        }
    }

    private static boolean isHeader(SyntaxTrivia syntaxTrivia) {
        return ((InternalSyntaxTrivia)syntaxTrivia).getLine() == 1;
    }

    private void leaveFile() {
        ArrayList commentedOutCodeLines = Lists.newArrayList();
        block0: for (SyntaxTrivia syntaxTrivia : this.comments) {
            String[] lines = syntaxTrivia.comment().split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!this.codeRecognizer.isLineOfCode(lines[i])) continue;
                for (int j = i; j < lines.length; ++j) {
                    commentedOutCodeLines.add(((InternalSyntaxTrivia)syntaxTrivia).getLine() + j);
                }
                continue block0;
            }
        }
        Collections.sort(commentedOutCodeLines);
        int prev = Integer.MIN_VALUE;
        for (int i = 0; i < commentedOutCodeLines.size(); ++i) {
            int current = (Integer)commentedOutCodeLines.get(i);
            if (prev + 1 < current) {
                this.addIssue(current, "This block of commented-out lines of code should be removed.");
            }
            prev = current;
        }
        this.comments = null;
    }

    private boolean isJavadoc(String comment) {
        return StringUtils.startsWith((String)comment, (String)"/**");
    }

    private boolean isJSNI(String comment) {
        return StringUtils.startsWith((String)comment, (String)START_JSNI) && StringUtils.endsWith((String)comment, (String)END_JSNI);
    }
}

