/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1186", name="Methods should not be empty", tags={"bug"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyMethodsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (!tree.modifiers().modifiers().contains(Modifier.ABSTRACT)) {
            super.visitClass(tree);
        } else {
            this.scan((ListTree)tree.modifiers());
            this.scan((ListTree)tree.typeParameters());
            this.scan((Tree)tree.superClass());
            this.scan(tree.superInterfaces());
            for (Tree memberTree : tree.members()) {
                if (memberTree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                    super.visitMethod((MethodTree)memberTree);
                    continue;
                }
                this.scan(memberTree);
            }
        }
    }

    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        BlockTree block = tree.block();
        if (block != null && block.body().isEmpty() && !tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && !EmptyMethodsCheck.containsComment(block)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Add a nested comment explaining why this method is empty, throw an UnsupportedOperationException or complete the implementation.");
        }
    }

    private static boolean containsComment(BlockTree tree) {
        AstNode blockAstNode = ((JavaTree)tree).getAstNode();
        return blockAstNode.getLastToken().hasTrivia();
    }
}

