/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractDeprecatedChecker;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1724", name="Deprecated classes and interfaces should not be extended/implemented", tags={"cwe", "obsolete"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ExtendDeprecatedSymbolCheck
extends AbstractDeprecatedChecker {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!this.hasDeprecatedAnnotation(tree)) {
            this.checkSuperTypeDeprecation(classTree.superClass(), false);
            for (TypeTree superInterface : classTree.superInterfaces()) {
                this.checkSuperTypeDeprecation(superInterface, true);
            }
        }
    }

    private void checkSuperTypeDeprecation(@Nullable TypeTree superTypeTree, boolean isInterface) {
        Type symbolType;
        if (superTypeTree != null && (symbolType = superTypeTree.symbolType()).isClass() && symbolType.symbol().isDeprecated()) {
            this.addIssue((Tree)superTypeTree, "\"" + symbolType.symbol().name() + "\"" + " is deprecated, " + (isInterface ? "implement" : "extend") + " the suggested replacement instead.");
        }
    }
}

