/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LeftCurlyBraceStartLineCheck", name="An open curly brace should be located at the beginning of a line", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LeftCurlyBraceStartLineCheck
extends SquidCheck<LexerlessGrammar>
implements JavaCheck {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.LWING});
    }

    public void visitNode(AstNode node) {
        if (!LeftCurlyBraceStartLineCheck.isExcluded(node) && node.getPreviousAstNode().getLastToken().getLine() == node.getTokenLine()) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this left curly brace to the beginning of next line of code.", node, new Object[0]);
        }
    }

    private static boolean isExcluded(AstNode node) {
        return node.getParent().is(new AstNodeType[]{Tree.Kind.NEW_ARRAY});
    }
}

