/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S864", name="Limited dependence should be placed on operator precedence rules in expressions", tags={"cert", "cwe", "misra"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class OperatorPrecedenceCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Table<Tree.Kind, Tree.Kind, Boolean> OPERATORS_RELATION_TABLE;
    private static final Set<Tree.Kind> ARITHMETIC_OPERATORS;
    private static final Set<Tree.Kind> EQUALITY_RELATIONAL_OPERATORS;
    private static final Set<Tree.Kind> SHIFT_OPERATORS;
    private JavaFileScannerContext context;
    private Deque<Tree.Kind> stack = new LinkedList<Tree.Kind>();

    private static void put(Iterable<Tree.Kind> firstSet, Iterable<Tree.Kind> secondSet) {
        for (Tree.Kind first : firstSet) {
            for (Tree.Kind second : secondSet) {
                OPERATORS_RELATION_TABLE.put((Object)first, (Object)second, (Object)true);
            }
        }
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAnnotation(AnnotationTree tree) {
        this.stack.push(null);
        for (ExpressionTree argument : tree.arguments()) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                this.scan((Tree)((AssignmentExpressionTree)argument).expression());
                continue;
            }
            this.scan((Tree)argument);
        }
        this.stack.pop();
    }

    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.scan((Tree)tree.expression());
        this.stack.push(null);
        this.scan((Tree)tree.index());
        this.stack.pop();
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Tree.Kind kind;
        Tree.Kind peek = this.stack.peek();
        if (this.requiresParenthesis(peek, kind = this.getKind((Tree)tree))) {
            this.raiseIssue((Tree)tree);
        }
        this.stack.push(kind);
        super.visitBinaryExpression(tree);
        this.stack.pop();
    }

    private boolean requiresParenthesis(Tree.Kind kind1, Tree.Kind kind2) {
        return BooleanUtils.isTrue((Boolean)((Boolean)OPERATORS_RELATION_TABLE.get((Object)kind1, (Object)kind2)));
    }

    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        ExpressionTree condition = tree.condition();
        if (condition.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && EQUALITY_RELATIONAL_OPERATORS.contains(this.getKind((Tree)((AssignmentExpressionTree)condition).expression()))) {
            this.raiseIssue((Tree)tree);
        }
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.scan((Tree)tree.methodSelect());
        this.scan((ListTree)tree.typeArguments());
        for (ExpressionTree argument : tree.arguments()) {
            this.stack.push(null);
            this.scan((Tree)argument);
            this.stack.pop();
        }
    }

    public void visitNewArray(NewArrayTree tree) {
        this.stack.push(null);
        super.visitNewArray(tree);
        this.stack.pop();
    }

    public void visitNewClass(NewClassTree tree) {
        this.stack.push(null);
        super.visitNewClass(tree);
        this.stack.pop();
    }

    public void visitParenthesized(ParenthesizedTree tree) {
        this.stack.push(null);
        super.visitParenthesized(tree);
        this.stack.pop();
    }

    private void raiseIssue(Tree tree) {
        this.context.addIssue(tree, (JavaCheck)this, "Add parentheses to make the operator precedence explicit.");
    }

    private Tree.Kind getKind(Tree tree) {
        return ((JavaTree)tree).getKind();
    }

    static {
        ARITHMETIC_OPERATORS = ImmutableSet.of((Object)Tree.Kind.MINUS, (Object)Tree.Kind.REMAINDER, (Object)Tree.Kind.MULTIPLY, (Object)Tree.Kind.PLUS);
        EQUALITY_RELATIONAL_OPERATORS = ImmutableSet.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.GREATER_THAN, (Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO, (Object)Tree.Kind.LESS_THAN, (Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object[])new Tree.Kind[0]);
        SHIFT_OPERATORS = ImmutableSet.of((Object)Tree.Kind.LEFT_SHIFT, (Object)Tree.Kind.RIGHT_SHIFT, (Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT);
        OPERATORS_RELATION_TABLE = HashBasedTable.create();
        OperatorPrecedenceCheck.put(ARITHMETIC_OPERATORS, Iterables.concat(SHIFT_OPERATORS, (Iterable)ImmutableSet.of((Object)Tree.Kind.AND, (Object)Tree.Kind.XOR, (Object)Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(SHIFT_OPERATORS, Iterables.concat(ARITHMETIC_OPERATORS, (Iterable)ImmutableSet.of((Object)Tree.Kind.AND, (Object)Tree.Kind.XOR, (Object)Tree.Kind.OR)));
        OperatorPrecedenceCheck.put((Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.AND), Iterables.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, (Iterable)ImmutableSet.of((Object)Tree.Kind.XOR, (Object)Tree.Kind.OR)));
        OperatorPrecedenceCheck.put((Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.XOR), Iterables.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, (Iterable)ImmutableSet.of((Object)Tree.Kind.AND, (Object)Tree.Kind.OR)));
        OperatorPrecedenceCheck.put((Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.OR), Iterables.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, (Iterable)ImmutableSet.of((Object)Tree.Kind.AND, (Object)Tree.Kind.XOR)));
        OperatorPrecedenceCheck.put((Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.CONDITIONAL_AND), (Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.CONDITIONAL_OR));
        OperatorPrecedenceCheck.put((Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.CONDITIONAL_OR), (Iterable<Tree.Kind>)ImmutableSet.of((Object)Tree.Kind.CONDITIONAL_AND));
    }
}

