/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00112", name="Generic exceptions should never be thrown", tags={"cwe", "error-handling"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="20min")
public class RawException_S00112_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Set<String> RAW_EXCEPTIONS = ImmutableSet.of((Object)"Throwable", (Object)"Error", (Object)"Exception", (Object)"RuntimeException");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        if ((tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || this.isNotOverriden(tree)) && !((MethodTreeImpl)tree).isMainMethod()) {
            for (TypeTree throwClause : tree.throwsClauses()) {
                this.checkExceptionAndRaiseIssue((Tree)throwClause);
            }
        }
        super.visitMethod(tree);
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.checkExceptionAndRaiseIssue((Tree)((NewClassTree)tree.expression()).identifier());
        }
        super.visitThrowStatement(tree);
    }

    private void checkExceptionAndRaiseIssue(Tree tree) {
        if (this.isRawException(tree)) {
            this.context.addIssue(tree, (JavaCheck)this, "Define and throw a dedicated exception instead of using a generic one.");
        }
    }

    private boolean isRawException(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && RAW_EXCEPTIONS.contains(((IdentifierTree)tree).name());
    }

    private boolean isNotOverriden(MethodTree tree) {
        return BooleanUtils.isFalse((Boolean)((MethodTreeImpl)tree).isOverriding());
    }
}

