/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RightCurlyBraceStartLineCheck", name="A close curly brace should be located at the beginning of a line", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class RightCurlyBraceStartLineCheck
extends SquidCheck<LexerlessGrammar>
implements JavaCheck {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.RWING});
    }

    public void visitNode(AstNode node) {
        if (!RightCurlyBraceStartLineCheck.isExcluded(node) && RightCurlyBraceStartLineCheck.hasSomeCodeBefore(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this closing curly brace to the next line.", node, new Object[0]);
        }
    }

    private static boolean hasSomeCodeBefore(AstNode node) {
        Token previousToken = RightCurlyBraceStartLineCheck.getPreviousToken(node);
        return previousToken != null && previousToken.getLine() == node.getTokenLine();
    }

    private static boolean isExcluded(AstNode node) {
        return node.getParent().is(new AstNodeType[]{Tree.Kind.NEW_ARRAY});
    }

    private static Token getPreviousToken(AstNode node) {
        AstNode result = node.getPreviousAstNode();
        while (result != null && !result.hasToken()) {
            while (result != null && !result.hasToken()) {
                result = result.getPreviousAstNode();
            }
            while (result != null && result.getLastChild() != null) {
                result = result.getLastChild();
            }
        }
        return result == null ? null : result.getToken();
    }
}

