/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1609", name="@FunctionalInterface annotation should be used to flag Single Abstract Method interfaces", tags={"java8"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class SAMAnnotatedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final ImmutableMultimap<String, List<String>> OBJECT_METHODS = new ImmutableMultimap.Builder().put((Object)"equals", (Object)ImmutableList.of((Object)"Object")).put((Object)"getClass", (Object)ImmutableList.of()).put((Object)"hashcode", (Object)ImmutableList.of()).put((Object)"notify", (Object)ImmutableList.of()).put((Object)"notifyAll", (Object)ImmutableList.of()).put((Object)"toString", (Object)ImmutableList.of()).put((Object)"wait", (Object)ImmutableList.of()).put((Object)"wait", (Object)ImmutableList.of((Object)"long")).put((Object)"wait", (Object)ImmutableList.of((Object)"long", (Object)"int")).build();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (this.isSAM(tree) && !this.isAnnotated(tree)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Annotate the \"" + tree.simpleName().name() + "\" interface with the @FunctionInterface annotation");
        }
        super.visitClass(tree);
    }

    private boolean isAnnotated(ClassTree tree) {
        for (AnnotationTree annotationTree : tree.modifiers().annotations()) {
            TypeTree annotationType = annotationTree.annotationType();
            if (!annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !"FunctionalInterface".equals(((IdentifierTree)annotationType).name())) continue;
            return true;
        }
        return false;
    }

    private boolean isSAM(ClassTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE}) && this.hasOneAbstractMethod(tree);
    }

    private boolean hasOneAbstractMethod(ClassTree classTree) {
        Symbol.TypeSymbol symbol = classTree.symbol();
        if (symbol != null) {
            List types = symbol.interfaces();
            for (Type type : types) {
                if (type.symbol().memberSymbols().isEmpty()) continue;
                return false;
            }
        }
        int methods = 0;
        for (Tree member : classTree.members()) {
            boolean isMethod = member.is(new Tree.Kind[]{Tree.Kind.METHOD});
            if (!isMethod) {
                return false;
            }
            if (!this.isNotObjectMethod((MethodTree)member) || !this.isNonStaticNonDefaultMethod(member)) continue;
            ++methods;
        }
        return methods == 1;
    }

    private boolean isNotObjectMethod(MethodTree method) {
        ImmutableCollection methods = OBJECT_METHODS.get((Object)method.simpleName().name());
        if (methods != null) {
            for (List arguments : methods) {
                ArrayList args = Lists.newArrayList((Iterable)arguments);
                if (method.parameters().size() != args.size()) continue;
                for (VariableTree var : method.parameters()) {
                    args.remove(var.type().symbolType().name());
                }
                if (!args.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isNonStaticNonDefaultMethod(Tree memberTree) {
        boolean result = memberTree.is(new Tree.Kind[]{Tree.Kind.METHOD});
        if (result) {
            MethodTree methodTree = (MethodTree)memberTree;
            List modifiers = methodTree.modifiers().modifiers();
            result = !modifiers.contains(Modifier.STATIC) && !modifiers.contains(Modifier.DEFAULT);
        }
        return result;
    }
}

