/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1191", name="Classes from \"sun.*\" packages should not be used", tags={"lock-in", "pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="COMPILER_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="1h")
public class SunPackagesUsedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private Set<Integer> reportedLines = new HashSet<Integer>();
    private static final String DEFAULT_EXCLUDE = "";
    @RuleProperty(key="Exclude", description="Comma separated list of Sun packages to be ignored by this rule. Example: com.sun.jna,sun.misc", defaultValue="")
    public String exclude = "";
    private String[] excludePackages = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.reportedLines.clear();
        this.excludePackages = this.exclude.split(",");
        this.scan((Tree)context.getTree());
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        String reference = this.merge((ExpressionTree)tree);
        if (!this.isExcluded(reference)) {
            int line = ((JavaTree)tree).getLine();
            if (!this.reportedLines.contains(line) && this.isSunClass(reference)) {
                this.context.addIssue(line, (JavaCheck)this, "Replace this usage of Sun classes by ones from the Java API.");
                this.reportedLines.add(line);
            }
            super.visitMemberSelectExpression(tree);
        }
    }

    private boolean isSunClass(String reference) {
        return "com.sun".equals(reference) || reference.matches("sun\\.[^\\.]*");
    }

    private String merge(ExpressionTree tree) {
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }

    private boolean isExcluded(String reference) {
        for (String str : this.excludePackages) {
            if (str.isEmpty() || !reference.startsWith(str)) continue;
            return true;
        }
        return false;
    }
}

