/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00103", name="Lines should not be too long", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TooLongLine_S00103_Check
extends SubscriptionBaseVisitor
implements CharsetAwareVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 120;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="120")
    public int maximumLineLength = 120;
    private Charset charset;
    private Set<Integer> ignoredLines = Sets.newHashSet();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.ignoredLines.clear();
        this.ignoreLines(context.getTree());
        super.scanFile(context);
        this.visitFile(context.getFile());
    }

    public void ignoreLines(CompilationUnitTree tree) {
        if (!tree.imports().isEmpty()) {
            int start = ((InternalSyntaxToken)((ImportTree)tree.imports().get(0)).importKeyword()).getLine();
            int end = ((InternalSyntaxToken)((ImportTree)tree.imports().get(tree.imports().size() - 1)).semicolonToken()).getLine();
            for (int i = start; i <= end; ++i) {
                this.ignoredLines.add(i);
            }
        }
    }

    private void visitFile(File file) {
        List lines;
        try {
            lines = Files.readLines((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line;
            if (this.ignoredLines.contains(i + 1) || (line = (String)lines.get(i)).length() <= this.maximumLineLength) continue;
            this.addIssue(i + 1, MessageFormat.format("Split this {0} characters long line (which is greater than {1} authorized).", line.length(), this.maximumLineLength));
        }
    }
}

