/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1172", name="Unused method parameters should be removed", tags={"misra", "unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedMethodParameterCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && methodTree.block() != null && !this.isExcluded(methodTree)) {
            ArrayList unused = Lists.newArrayList();
            for (VariableTree var : methodTree.parameters()) {
                Symbol sym = var.symbol();
                if (sym == null || !sym.usages().isEmpty()) continue;
                unused.add(var.simpleName().name());
            }
            if (!unused.isEmpty()) {
                this.addIssue((Tree)methodTree, "Remove the unused method parameter(s) \"" + Joiner.on((String)",").join((Iterable)unused) + "\".");
            }
        }
    }

    private boolean isExcluded(MethodTree tree) {
        return ((MethodTreeImpl)tree).isMainMethod() || this.isOverriding(tree) || this.isSerializableMethod(tree) || this.isDesignedForExtension(tree);
    }

    private boolean isDesignedForExtension(MethodTree tree) {
        return !tree.modifiers().modifiers().contains(Modifier.PRIVATE) && this.isEmptyOrThrowStatement(tree.block());
    }

    private boolean isEmptyOrThrowStatement(BlockTree block) {
        return block.body().isEmpty() || block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT});
    }

    private boolean isSerializableMethod(MethodTree methodTree) {
        boolean result = false;
        if (methodTree.modifiers().modifiers().contains(Modifier.PRIVATE) && methodTree.parameters().size() == 1) {
            result |= "writeObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 1;
            result |= "readObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 2;
        }
        return result;
    }

    private boolean isOverriding(MethodTree tree) {
        return !BooleanUtils.isFalse((Boolean)((MethodTreeImpl)tree).isOverriding());
    }
}

