/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.symexec.ExecutionState;
import org.sonar.java.symexec.SymbolicBooleanConstraint;
import org.sonar.java.symexec.SymbolicEvaluator;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2583", name="Conditions should not unconditionally evaluate to \"TRUE\" or to \"FALSE\"", tags={"bug", "cwe", "misra"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class UselessConditionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private SymbolicEvaluator engine = new SymbolicEvaluator();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        for (Map.Entry<Tree, SymbolicBooleanConstraint> entry : this.engine.evaluateMethod(new ExecutionState(), tree).entrySet()) {
            switch (entry.getValue()) {
                case FALSE: {
                    this.raiseIssue(entry.getKey(), "false");
                    break;
                }
                case TRUE: {
                    this.raiseIssue(entry.getKey(), "true");
                    break;
                }
            }
        }
    }

    private void raiseIssue(Tree tree, String value) {
        this.context.addIssue(tree, (JavaCheck)this, String.format("Change this condition so that it does not always evaluate to \"%s\"", value));
    }
}

