/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Resource;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squid.api.SourceFile;

public class FileLinesVisitor
extends JavaAstVisitor
implements AstAndTokenVisitor {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final Charset charset;
    private final Set<Integer> linesOfCode = Sets.newHashSet();
    private final Set<Integer> linesOfComments = Sets.newHashSet();

    public FileLinesVisitor(FileLinesContextFactory fileLinesContextFactory, Charset charset) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.charset = charset;
    }

    public void leaveFile(AstNode astNode) {
        int fileLength;
        SourceFile file = (SourceFile)this.getContext().peekSourceCode();
        JavaFile javaFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)file.getKey());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor((Resource)javaFile);
        try {
            fileLength = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset).size();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        for (int line = 1; line <= fileLength; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, this.linesOfComments.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
    }

    public void visitToken(Token token) {
        if (token.getType().equals(GenericTokenType.EOF)) {
            return;
        }
        this.linesOfCode.add(token.getLine());
        List trivias = token.getTrivia();
        for (Trivia trivia : trivias) {
            if (!trivia.isComment()) continue;
            int baseLine = trivia.getToken().getLine();
            String[] lines = trivia.getToken().getOriginalValue().split("(\r)?\n|\r", -1);
            for (int i = 0; i < lines.length; ++i) {
                this.linesOfComments.add(baseLine + i);
            }
        }
    }
}

