/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.java.bytecode.asm.SourceCodeEdgeUsage;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class LCOM4Visitor
extends BytecodeVisitor {
    private AsmClass asmClass;
    private List<Set<AsmResource>> unrelatedBlocks = null;
    private final Set<String> fieldsToExcludeFromLcom4Calculation;

    public LCOM4Visitor(Set<String> fieldsToExcludeFromLcom4Calculation) {
        this.fieldsToExcludeFromLcom4Calculation = fieldsToExcludeFromLcom4Calculation;
    }

    @Override
    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
        this.unrelatedBlocks = new ArrayList<Set<AsmResource>>();
    }

    @Override
    public void visitMethod(AsmMethod asmMethod) {
        if (this.isMethodElligibleForLCOM4Computation(asmMethod)) {
            this.ensureBlockIsCreated(asmMethod);
            for (AsmEdge edge : asmMethod.getOutgoingEdges()) {
                if (!this.isCallToInternalFieldOrMethod(edge) || !this.isNotCallToExcludedFieldFromLcom4Calculation(edge.getTo())) continue;
                AsmResource toResource = this.getAccessedFieldOrMethod(edge.getTo());
                this.linkAsmResources(asmMethod, toResource);
            }
        }
    }

    private AsmResource getAccessedFieldOrMethod(AsmResource resource) {
        if (resource instanceof AsmMethod && ((AsmMethod)resource).isAccessor()) {
            return ((AsmMethod)resource).getAccessedField();
        }
        return resource;
    }

    private boolean isNotCallToExcludedFieldFromLcom4Calculation(AsmResource to) {
        if (to instanceof AsmField) {
            AsmField field = (AsmField)to;
            return !this.fieldsToExcludeFromLcom4Calculation.contains(field.getName());
        }
        return true;
    }

    private boolean isMethodElligibleForLCOM4Computation(AsmMethod asmMethod) {
        return !asmMethod.isAbstract() && !asmMethod.isStatic() && !asmMethod.isConstructor() && !asmMethod.isEmpty() && !asmMethod.isAccessor() && asmMethod.isBodyLoaded();
    }

    private void removeIsolatedMethodBlocks() {
        Iterator<Set<AsmResource>> iterator = this.unrelatedBlocks.iterator();
        while (iterator.hasNext()) {
            Set<AsmResource> block = iterator.next();
            if (block.size() != 1) continue;
            iterator.remove();
        }
    }

    @Override
    public void leaveClass(AsmClass asmClass) {
        this.removeIsolatedMethodBlocks();
        int lcom4 = this.unrelatedBlocks.size();
        if (lcom4 == 0) {
            lcom4 = 1;
        }
        this.getSourceClass(asmClass).add((MetricDef)Metric.LCOM4, (double)lcom4);
        this.getSourceClass(asmClass).addData((MetricDef)Metric.LCOM4_BLOCKS, this.unrelatedBlocks);
        if (this.isMainPublicClassInFile(asmClass)) {
            this.getSourceFile(asmClass).add((MetricDef)Metric.LCOM4, (double)lcom4);
            this.getSourceFile(asmClass).addData((MetricDef)Metric.LCOM4_BLOCKS, this.unrelatedBlocks);
        }
    }

    private void ensureBlockIsCreated(AsmResource resource) {
        this.getOrCreateResourceBlock(resource);
    }

    private void linkAsmResources(AsmResource resourceA, AsmResource resourceB) {
        Set<AsmResource> blockB;
        Set<AsmResource> blockA = this.getOrCreateResourceBlock(resourceA);
        if (blockA == (blockB = this.getOrCreateResourceBlock(resourceB))) {
            return;
        }
        blockA.addAll(blockB);
        this.unrelatedBlocks.remove(blockB);
    }

    private boolean isCallToInternalFieldOrMethod(AsmEdge edge) {
        return edge.getTargetAsmClass() == this.asmClass && (edge.getUsage() == SourceCodeEdgeUsage.CALLS_FIELD || edge.getUsage() == SourceCodeEdgeUsage.CALLS_METHOD);
    }

    private Set<AsmResource> getOrCreateResourceBlock(AsmResource resource) {
        for (Set<AsmResource> block : this.unrelatedBlocks) {
            if (!block.contains(resource)) continue;
            return block;
        }
        HashSet<AsmResource> block = new HashSet<AsmResource>();
        block.add(resource);
        this.unrelatedBlocks.add(block);
        return block;
    }

    public String toString() {
        return "Lack of Cohesion (LCOM4) metric";
    }
}

