/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SonarSymbolTableVisitor
extends BaseTreeVisitor {
    private SemanticModel semanticModel;
    private Symbolizable symbolizable;
    private Symbolizable.SymbolTableBuilder symbolTableBuilder;
    private CompilationUnitTree outerClass;

    public SonarSymbolTableVisitor(Symbolizable symbolizable, SemanticModel semanticModel) {
        this.symbolizable = symbolizable;
        this.semanticModel = semanticModel;
        this.symbolTableBuilder = symbolizable.newSymbolTableBuilder();
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (this.outerClass == null) {
            this.outerClass = tree;
        }
        super.visitCompilationUnit(tree);
        if (tree.equals(this.outerClass)) {
            this.symbolizable.setSymbolTable(this.symbolTableBuilder.build());
        }
    }

    public void visitClass(ClassTree tree) {
        if (tree.simpleName() != null) {
            this.createSymbol((Tree)tree, tree.simpleName());
        }
        super.visitClass(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.createSymbol((Tree)tree, tree.simpleName());
        super.visitVariable(tree);
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.createSymbol((Tree)tree, tree.simpleName());
        super.visitEnumConstant(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.createSymbol((Tree)tree, tree.simpleName());
        super.visitMethod(tree);
    }

    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.createSymbol((Tree)tree, tree.label());
        super.visitLabeledStatement(tree);
    }

    public void visitImport(ImportTree tree) {
        IdentifierTree identifierTree = tree.qualifiedIdentifier().is(Tree.Kind.IDENTIFIER) ? (IdentifierTree)tree.qualifiedIdentifier() : ((MemberSelectExpressionTree)tree.qualifiedIdentifier()).identifier();
        this.createSymbol((Tree)tree, identifierTree);
        super.visitImport(tree);
    }

    private void createSymbol(Tree tree, IdentifierTree identifier) {
        Symbol symbol = this.symbolTableBuilder.newSymbol(this.startOffsetFor(identifier), this.endOffsetFor(identifier));
        for (IdentifierTree usage : this.semanticModel.getUsages(this.semanticModel.getSymbol(tree))) {
            this.symbolTableBuilder.newReference(symbol, this.startOffsetFor(usage));
        }
    }

    private int startOffsetFor(IdentifierTree tree) {
        AstNode astNode = ((JavaTree)tree).getAstNode();
        return astNode.getFromIndex();
    }

    private int endOffsetFor(IdentifierTree tree) {
        AstNode astNode = ((JavaTree)tree).getAstNode();
        return astNode.getFromIndex() + astNode.getTokenValue().length();
    }
}

