/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.sslr.parser.LexerlessGrammar;

public class FileVisitor
extends SquidAstVisitor<LexerlessGrammar> {
    public void visitFile(AstNode astNode) {
        SourceFile sourceFile = this.createSourceFile(this.getContext().getFile());
        this.getContext().addSourceCode((SourceCode)sourceFile);
    }

    public void leaveFile(AstNode astNode) {
        Preconditions.checkState((boolean)this.getContext().peekSourceCode().isType(SourceFile.class));
        this.getContext().popSourceCode();
    }

    private SourceFile createSourceFile(File file) {
        return new SourceFile(file.getAbsolutePath(), file.getPath());
    }
}

