/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameterTree;

public class TypeParameterTreeImpl
extends JavaTree
implements TypeParameterTree {
    private IdentifierTreeImpl identifier;
    private final List<Tree> bounds;

    public TypeParameterTreeImpl(IdentifierTreeImpl identifier) {
        super(Tree.Kind.TYPE_PARAMETER);
        this.identifier = identifier;
        this.bounds = Collections.emptyList();
        this.addChild(identifier);
    }

    public TypeParameterTreeImpl(InternalSyntaxToken extendsToken, BoundListTreeImpl bounds) {
        super(Tree.Kind.TYPE_PARAMETER);
        this.bounds = bounds;
        this.addChild(extendsToken);
        this.addChild(bounds);
    }

    public TypeParameterTreeImpl complete(IdentifierTreeImpl identifier) {
        Preconditions.checkState((this.identifier == null ? 1 : 0) != 0);
        this.identifier = identifier;
        this.prependChildren(identifier);
        return this;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParameter(this);
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public List<Tree> bounds() {
        return this.bounds;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_PARAMETER;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.identifier()), this.bounds().iterator());
    }
}

