/*
 * SonarQube Java
 * Copyright (C) 2012 SonarSource
 * dev@sonar.codehaus.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.ast.parser;

import com.sonar.sslr.api.AstNode;
import org.sonar.plugins.java.api.tree.TypeTree;

import java.util.List;

public class QualifiedIdentifierListTreeImpl extends ListTreeImpl<TypeTree> {

  public QualifiedIdentifierListTreeImpl(List<? extends TypeTree> qualifiedIdentifiers, List<AstNode> children) {
    super(JavaLexer.QUALIFIED_IDENTIFIER_LIST, (List<TypeTree>) qualifiedIdentifiers, children);
  }

}
