/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="StrictMode", priority=Priority.INFO)
@BelongsToProfile(title="Sonar way", priority=Priority.INFO)
public class StrictModeCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statement});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if ("\"use strict\"".equals(value) || "'use strict'".equals(value)) {
            this.getContext().createLineViolation((CodeCheck)this, "Use of JavaScript strict mode may result in unexpected behaviour in some browsers.", astNode, new Object[0]);
        }
    }
}

