/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="CollapsibleIfStatements", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CollapsibleIfStatementsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode node) {
        AstNode innerStatement;
        if (this.isIfStatementWithoutElse(node) && (this.isBlockAndContainsOnlyOneIfStatement(innerStatement = node.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.STATEMENT}).getFirstChild()) || this.isIfStatementWithoutElse(innerStatement))) {
            this.getContext().createLineViolation((CodeCheck)this, "Those two 'if' statements can be consolidated.", node, new Object[0]);
        }
    }

    private boolean isBlockAndContainsOnlyOneIfStatement(AstNode statement) {
        if (!statement.is(new AstNodeType[]{EcmaScriptGrammar.BLOCK})) {
            return false;
        }
        AstNode statementList = statement.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.STATEMENT_LIST});
        if (statementList == null || statementList.getNumberOfChildren() != 1 || statementList.getFirstChild().isNot(new AstNodeType[]{EcmaScriptGrammar.STATEMENT})) {
            return false;
        }
        return this.isIfStatementWithoutElse(statementList.getFirstChild().getFirstChild());
    }

    private boolean isIfStatementWithoutElse(AstNode statement) {
        return !statement.isNot(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT}) && !statement.hasDirectChildren(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE});
    }
}

