/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="HtmlComments", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class HtmlCommentsCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment() || !trivia.getToken().getValue().startsWith("<!--")) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Replace this HTML-style comment by a standard comment", trivia.getToken().getLine(), new Object[0]);
        }
    }
}

