/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.DoWhileStatementTree;
import org.sonar.javascript.model.ForInStatementTree;
import org.sonar.javascript.model.ForStatementTree;
import org.sonar.javascript.model.LabelledStatementTree;
import org.sonar.javascript.model.StatementTree;
import org.sonar.javascript.model.TreeVisitor;
import org.sonar.javascript.model.WhileStatementTree;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LabelPlacement", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LabelPlacementCheck
extends SquidCheck<LexerlessGrammar>
implements TreeVisitor {
    public void visit(LabelledStatementTree labelledStatementTree) {
        if (!LabelPlacementCheck.isIterationStatement(labelledStatementTree.statement())) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this label.", labelledStatementTree.getLine(), new Object[0]);
        }
    }

    private static boolean isIterationStatement(StatementTree statement) {
        return statement.is(DoWhileStatementTree.class) || statement.is(WhileStatementTree.class) || statement.is(ForInStatementTree.class) || statement.is(ForStatementTree.class);
    }
}

