/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="MultilineStringLiterals", priority=Priority.BLOCKER)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MultilineStringLiteralsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.STRING_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getTokenValue().contains("\n")) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid multiline string literals.", astNode, new Object[0]);
        }
    }
}

