/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnusedFunctionArgument", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedFunctionArgumentCheck
extends SquidCheck<LexerlessGrammar> {
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FORMAL_PARAMETER_LIST, EcmaScriptGrammar.PRIMARY_EXPRESSION});
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void visitNode(AstNode astNode) {
        AstNode identifierNode;
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.currentScope = new Scope(this.currentScope, astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
            for (AstNode identifierNode2 : astNode.getChildren(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) {
                this.currentScope.declare(identifierNode2);
            }
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION}) && (identifierNode = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) != null) {
            if ("arguments".equals(identifierNode.getTokenValue())) {
                this.currentScope.useArgumentsArray = true;
            }
            this.currentScope.use(identifierNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            if (!this.currentScope.useArgumentsArray) {
                this.reportUnusedArguments(astNode);
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void reportUnusedArguments(AstNode functionNode) {
        if (functionNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.reportAllUnusedArgs();
        } else {
            this.reportDanglingUnusedArgs();
        }
    }

    public void reportAllUnusedArgs() {
        int nbUnusedArgs = 0;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.currentScope.arguments.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            builder.append((String)entry.getKey() + " ");
            ++nbUnusedArgs;
        }
        this.createIssue(builder, false, nbUnusedArgs);
    }

    public void reportDanglingUnusedArgs() {
        int nbUnusedArgs = 0;
        boolean hasMetUsedArg = false;
        StringBuilder builder = new StringBuilder();
        ArrayList entries = Lists.newArrayList(this.currentScope.arguments.entrySet());
        for (Map.Entry entry : Lists.reverse((List)entries)) {
            int usages = (Integer)entry.getValue();
            if (usages == 0 && !hasMetUsedArg) {
                builder.append((String)entry.getKey() + " ");
                ++nbUnusedArgs;
                continue;
            }
            if (usages <= 0 || hasMetUsedArg) continue;
            hasMetUsedArg = true;
        }
        this.createIssue(builder, true, nbUnusedArgs);
    }

    public void createIssue(StringBuilder builder, boolean reverse, int nbArgs) {
        if (nbArgs > 1) {
            String argsList;
            if (reverse) {
                Object[] args = builder.deleteCharAt(builder.length() - 1).toString().split(" ");
                ArrayUtils.reverse((Object[])args);
                argsList = StringUtils.join((Object[])args, (String)", ");
            } else {
                argsList = StringUtils.join((Object[])builder.toString().split(" "), (String)", ");
            }
            this.getContext().createLineViolation((CodeCheck)this, "Remove the unused function parameters \"" + argsList + "\".", this.currentScope.functionDec, new Object[0]);
        } else if (nbArgs == 1) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the unused function parameter \"" + builder.toString().trim() + "\".", this.currentScope.functionDec, new Object[0]);
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final AstNode functionDec;
        private final Map<String, Integer> arguments;
        private boolean useArgumentsArray = false;

        public Scope(Scope outerScope, AstNode functionDec) {
            this.outerScope = outerScope;
            this.functionDec = functionDec;
            this.arguments = Maps.newLinkedHashMap();
        }

        private void declare(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            this.arguments.put(identifier, 0);
        }

        private void use(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                Integer usage = scope.arguments.get(identifier);
                if (usage != null) {
                    Integer n = usage;
                    Integer n2 = usage = Integer.valueOf(usage + 1);
                    scope.arguments.put(identifier, usage);
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }
}

