/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1067", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ExpressionComplexityCheck
extends SquidCheck<LexerlessGrammar> {
    private List<ExpressionComplexity> statementLevel = Lists.newArrayList();
    private static final int DEFAULT = 3;
    private static final GrammarRuleKey[] LOGICAL_AND_CONDITIONAL_EXPRS = new GrammarRuleKey[]{EcmaScriptGrammar.CONDITIONAL_EXPRESSION, EcmaScriptGrammar.LOGICAL_AND_EXPRESSION, EcmaScriptGrammar.LOGICAL_OR_EXPRESSION};
    private static final GrammarRuleKey[] EXPRESSIONS = new GrammarRuleKey[]{EcmaScriptGrammar.EXPRESSION, EcmaScriptGrammar.EXPRESSION_NO_IN};
    @RuleProperty(defaultValue="3")
    public int max = 3;

    public void visitFile(@Nullable AstNode astNode) {
        this.statementLevel.clear();
        this.statementLevel.add(new ExpressionComplexity());
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION});
        this.subscribeTo((AstNodeType[])EXPRESSIONS);
        this.subscribeTo((AstNodeType[])LOGICAL_AND_CONDITIONAL_EXPRS);
    }

    public void visitNode(AstNode astNode) {
        if (ExpressionComplexityCheck.isExpression(astNode)) {
            ((ExpressionComplexity)Iterables.getLast(this.statementLevel)).incrementNestedExprLevel();
        }
        if (astNode.is((AstNodeType[])LOGICAL_AND_CONDITIONAL_EXPRS)) {
            ((ExpressionComplexity)Iterables.getLast(this.statementLevel)).increaseOperatorCounter(astNode.getChildren(new AstNodeType[]{EcmaScriptPunctuator.OROR, EcmaScriptPunctuator.ANDAND, EcmaScriptPunctuator.QUERY}).size());
        }
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.statementLevel.add(new ExpressionComplexity());
        }
    }

    public void leaveNode(AstNode astNode) {
        if (ExpressionComplexityCheck.isExpression(astNode)) {
            ExpressionComplexity currentExpression = (ExpressionComplexity)Iterables.getLast(this.statementLevel);
            currentExpression.decrementNestedExprLevel();
            if (currentExpression.isOnFirstExprLevel()) {
                if (currentExpression.getExprNumberOfOperator() > this.max) {
                    this.getContext().createLineViolation((CodeCheck)this, "Reduce the number of conditional operators (" + currentExpression.getExprNumberOfOperator() + ") used in the expression (maximum allowed " + this.max + ").", astNode, new Object[0]);
                }
                currentExpression.resetExprOperatorCounter();
            }
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.statementLevel.remove(this.statementLevel.size() - 1);
        }
    }

    public static boolean isExpression(AstNode node) {
        return node.is((AstNodeType[])EXPRESSIONS) || ExpressionComplexityCheck.isLogicalOrConditionalExpr(node);
    }

    public static boolean isLogicalOrConditionalExpr(AstNode node) {
        return node.is((AstNodeType[])LOGICAL_AND_CONDITIONAL_EXPRS) && node.getParent().isNot(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION});
    }

    public static class ExpressionComplexity {
        private int nestedLevel = 0;
        private int counterOperator = 0;

        public void increaseOperatorCounter(int nbOperator) {
            this.counterOperator += nbOperator;
        }

        public void incrementNestedExprLevel() {
            ++this.nestedLevel;
        }

        public void decrementNestedExprLevel() {
            --this.nestedLevel;
        }

        public boolean isOnFirstExprLevel() {
            return this.nestedLevel == 0;
        }

        public int getExprNumberOfOperator() {
            return this.counterOperator;
        }

        public void resetExprOperatorCounter() {
            this.counterOperator = 0;
        }
    }
}

