/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="EqEqEq", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EqEqEqCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL});
    }

    public void visitNode(AstNode node) {
        if (!this.comparesWithNull(node)) {
            if (node.is(new AstNodeType[]{EcmaScriptPunctuator.EQUAL})) {
                this.getContext().createLineViolation((CodeCheck)this, "Replace \"==\" with \"===\".", node, new Object[0]);
            } else if (node.is(new AstNodeType[]{EcmaScriptPunctuator.NOTEQUAL})) {
                this.getContext().createLineViolation((CodeCheck)this, "Replace \"!=\" with \"!==\".", node, new Object[0]);
            }
        }
    }

    public boolean comparesWithNull(AstNode node) {
        return EcmaScriptKeyword.NULL.getValue().equals(node.getNextSibling().getTokenValue());
    }
}

