/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S878", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CommaOperatorUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        if (!CommaOperatorUseCheck.containsCommaOperator(astNode) || CommaOperatorUseCheck.isInitOrIncrementOfForLoop(astNode) || CommaOperatorUseCheck.isArrowFunctionParameter(astNode)) {
            return;
        }
        List commas = astNode.getChildren(new AstNodeType[]{EcmaScriptPunctuator.COMMA});
        if (commas.size() == 1) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove use of this comma operator.", (AstNode)commas.get(0), new Object[0]);
        } else {
            this.getContext().createLineViolation((CodeCheck)this, "Remove use of all comma operators in this expression.", (AstNode)commas.get(0), new Object[0]);
        }
    }

    private static boolean isArrowFunctionParameter(AstNode expr) {
        return expr.getParent().getParent().is(new AstNodeType[]{EcmaScriptGrammar.ARROW_PARAMETERS});
    }

    public static boolean isInitOrIncrementOfForLoop(AstNode expr) {
        return expr.getParent().is(new AstNodeType[]{EcmaScriptGrammar.FOR_STATEMENT});
    }

    public static boolean containsCommaOperator(AstNode expr) {
        return expr.hasDirectChildren(new AstNodeType[]{EcmaScriptPunctuator.COMMA});
    }
}

