/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ArrayAndObjectConstructors", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ArrayAndObjectConstructorsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptKeyword.NEW});
    }

    public void visitNode(AstNode astNode) {
        if ("Array".equals(astNode.getNextSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Use a literal instead of the Array constructor.", astNode, new Object[0]);
        }
        if ("Object".equals(astNode.getNextSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Use a literal instead of the Object constructor.", astNode, new Object[0]);
        }
    }
}

