/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.FunctionDeclarationTree;
import org.sonar.javascript.model.interfaces.expression.FunctionExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SameNameForFunctionAndVariable", priority=Priority.MAJOR, tags={"brain-overload", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SameNameForFunctionAndVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> variablesStack;
    private Stack<Set<String>> functionsStack;
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION};

    public void init() {
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
    }

    public void visitFile(AstNode astNode) {
        this.variablesStack = new Stack();
        this.variablesStack.add(new HashSet());
        this.functionsStack = new Stack();
        this.functionsStack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION})) {
            this.checkFunctionName(astNode, ((FunctionDeclarationTree)astNode).name());
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION})) {
            this.checkFunctionName(astNode, ((FunctionExpressionTree)astNode).name());
        } else if (astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
            for (IdentifierTree identifier : ((VariableDeclarationTreeImpl)astNode).variableIdentifiers()) {
                String variableName = identifier.name();
                this.check((AstNode)identifier, this.functionsStack.peek(), variableName);
                this.variablesStack.peek().add(variableName);
            }
        }
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.variablesStack.add(new HashSet());
            this.functionsStack.add(new HashSet());
        }
    }

    private void checkFunctionName(AstNode functionNode, IdentifierTree nameIdentifier) {
        if (nameIdentifier != null) {
            String functionName = nameIdentifier.name();
            this.check(functionNode, this.variablesStack.peek(), functionName);
            this.functionsStack.peek().add(functionName);
        }
    }

    private void check(AstNode astNode, Set<String> names, String name) {
        if (names.contains(name)) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor the code to avoid using \"" + name + "\" for both a variable and a function.", astNode, new Object[0]);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.variablesStack.pop();
            this.functionsStack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.variablesStack = null;
        this.functionsStack = null;
    }
}

