/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S878", name="Comma operator should not be used", priority=Priority.MAJOR, tags={"misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CommaOperatorUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.COMMA_OPERATOR});
    }

    public void visitNode(AstNode astNode) {
        if (CommaOperatorUseCheck.isInCommaExpression(astNode) || CommaOperatorUseCheck.isInitOrIncrementOfForLoop(astNode)) {
            return;
        }
        BinaryExpressionTree expr = (BinaryExpressionTree)astNode;
        String message = expr.leftOperand().is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR}) ? "Remove use of all comma operators in this expression." : "Remove use of this comma operator.";
        while (expr.leftOperand().is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            expr = (BinaryExpressionTree)expr.leftOperand();
        }
        SyntaxToken operator = expr.operator();
        this.getContext().createLineViolation((CodeCheck)this, message, (AstNode)((InternalSyntaxToken)operator), new Object[0]);
    }

    public static boolean isInCommaExpression(AstNode expr) {
        return expr.getParent().is(new AstNodeType[]{Tree.Kind.COMMA_OPERATOR});
    }

    public static boolean isInitOrIncrementOfForLoop(AstNode expr) {
        return expr.getParent().is(new AstNodeType[]{Tree.Kind.FOR_STATEMENT}) && (expr.getPreviousAstNode().is(new AstNodeType[]{EcmaScriptPunctuator.LPARENTHESIS}) || expr.getNextAstNode().is(new AstNodeType[]{EcmaScriptPunctuator.RPARENTHESIS}));
    }
}

