/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ConditionalComment", name="Internet Explorer's conditional comments should not be used", priority=Priority.MAJOR, tags={"cross-browser"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ConditionalCommentCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment;
            if (!trivia.isComment() || !(comment = trivia.getToken().getValue()).startsWith("/*@cc_on") && !comment.startsWith("//@cc_on")) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Refactor your code to avoid using Internet Explorer's conditional comments.", trivia.getToken(), new Object[0]);
        }
    }
}

