/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.LabelledStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1219", name="\"switch\" statements should not contain non-case labels", priority=Priority.CRITICAL, tags={"misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class NonCaseLabelInSwitchCheck
extends SquidCheck<LexerlessGrammar> {
    private boolean inCase;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.LABELLED_STATEMENT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.inCase = false;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.CASE_CLAUSE})) {
            this.inCase = true;
        } else if (this.inCase && astNode.is(new AstNodeType[]{Tree.Kind.LABELLED_STATEMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this misleading \"{0}\" label.", astNode, new Object[]{((LabelledStatementTree)astNode).label().name()});
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.CASE_CLAUSE})) {
            this.inCase = false;
        }
    }
}

