/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.AstTreeVisitorContext;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2137", name="Local variables should not shadow \"undefined\"", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class UndefinedShadowingCheck
extends SubscriptionBaseVisitor {
    private int scopeLevel = 0;

    public void scanFile(AstTreeVisitorContext context) {
        this.scopeLevel = 0;
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().addAll(CheckUtils.FUNCTION_NODES).add((Object)Tree.Kind.VAR_DECLARATION).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(CheckUtils.functionNodesArray())) {
            ++this.scopeLevel;
        } else if (this.scopeLevel > 0) {
            for (IdentifierTree identifier : ((VariableDeclarationTreeImpl)tree).variableIdentifiers()) {
                if (!"undefined".equals(identifier.name())) continue;
                this.addIssue((Tree)identifier, "Rename this variable.");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CheckUtils.functionNodesArray())) {
            --this.scopeLevel;
        }
    }
}

