/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.coverage;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.javascript.coverage.JavaScriptFileCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LCOVParser {
    private static final Logger LOG = LoggerFactory.getLogger(LCOVParser.class);

    public List<JavaScriptFileCoverage> parseFile(File file) {
        List lines = new LinkedList();
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            LOG.debug("Cound not read content from file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        LinkedList<JavaScriptFileCoverage> coveredFiles = new LinkedList<JavaScriptFileCoverage>();
        JavaScriptFileCoverage fileCoverage = new JavaScriptFileCoverage();
        for (String line : lines) {
            if (line.indexOf("SF:") > -1) {
                fileCoverage = new JavaScriptFileCoverage();
                String filePath = line.substring(line.indexOf("SF:") + 3);
                fileCoverage.setFilePath(filePath);
                continue;
            }
            if (line.indexOf("DA:") > -1) {
                String execution = line.substring(line.indexOf("DA:") + 3);
                String executionCount = execution.substring(execution.indexOf(44) + 1);
                String lineNumber = execution.substring(0, execution.indexOf(44));
                fileCoverage.addLine(Integer.valueOf(lineNumber), Integer.valueOf(executionCount));
                continue;
            }
            if (line.indexOf("end_of_record") <= -1) continue;
            coveredFiles.add(fileCoverage);
        }
        return coveredFiles;
    }
}

