/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.JavaScriptAstScanner;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.checks.CheckList;
import org.sonar.javascript.metrics.FileLinesVisitor;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.indexer.QueryByParent;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class JavaScriptSquidSensor
implements Sensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final AnnotationCheckFactory annotationCheckFactory;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final ModuleFileSystem moduleFileSystem;
    private final NoSonarFilter noSonarFilter;
    private Project project;
    private SensorContext context;
    private AstScanner<LexerlessGrammar> scanner;

    public JavaScriptSquidSensor(RulesProfile profile, FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, ModuleFileSystem moduleFileSystem, NoSonarFilter noSonarFilter) {
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"javascript", (Collection)CheckList.getChecks());
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.moduleFileSystem = moduleFileSystem;
        this.noSonarFilter = noSonarFilter;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.moduleFileSystem.files(FileQuery.onSource().onLanguage(new String[]{"js"})).isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        this.project = project;
        this.context = context;
        Collection squidChecks = this.annotationCheckFactory.getChecks();
        ArrayList visitors = Lists.newArrayList((Iterable)squidChecks);
        visitors.add(new FileLinesVisitor(project, this.fileLinesContextFactory));
        this.scanner = JavaScriptAstScanner.create((EcmaScriptConfiguration)this.createConfiguration(project), (SquidAstVisitor[])visitors.toArray(new SquidAstVisitor[visitors.size()]));
        this.scanner.scanFiles((Collection)this.moduleFileSystem.files(FileQuery.onSource().onLanguage(new String[]{"js"})));
        Collection squidSourceFiles = this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        this.save(squidSourceFiles);
    }

    private EcmaScriptConfiguration createConfiguration(Project project) {
        return new EcmaScriptConfiguration(this.moduleFileSystem.sourceCharset());
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)new File(squidFile.getKey()), (Project)this.project);
            this.noSonarFilter.addResource((Resource)sonarFile, squidFile.getNoSonarTagLines());
            this.saveClassComplexity(sonarFile, squidFile);
            this.saveFilesComplexityDistribution(sonarFile, squidFile);
            this.saveFunctionsComplexityAndDistribution(sonarFile, squidFile);
            this.saveMeasures(sonarFile, squidFile);
            this.saveIssues(sonarFile, squidFile);
        }
    }

    private void saveMeasures(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.LINES_OF_CODE)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.CLASSES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.FUNCTIONS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.ACCESSORS, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.ACCESSORS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.STATEMENTS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.COMMENT_LINES)));
    }

    private void saveClassComplexity(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        double complexityInClasses = 0.0;
        Set children = squidFile.getChildren();
        if (children != null) {
            for (SourceCode sourceCode : squidFile.getChildren()) {
                if (!sourceCode.isType(SourceClass.class)) continue;
                complexityInClasses += sourceCode.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY);
            }
        }
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY_IN_CLASSES, Double.valueOf(complexityInClasses));
    }

    private void saveFunctionsComplexityAndDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        double complexityInFunction = 0.0;
        for (SourceCode squidFunction : squidFunctionsInFile) {
            double functionComplexity = squidFunction.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY);
            complexityDistribution.add((Number)functionComplexity);
            complexityInFunction += functionComplexity;
        }
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY_IN_FUNCTIONS, Double.valueOf(complexityInFunction));
    }

    private void saveFilesComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY));
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveIssues(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage message : messages) {
                ActiveRule rule = this.annotationCheckFactory.getActiveRule(message.getCheck());
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)sonarFile);
                if (issuable == null) continue;
                Issue issue = issuable.newIssueBuilder().ruleKey(RuleKey.of((String)rule.getRepositoryKey(), (String)rule.getRuleKey())).line(message.getLine()).message(message.getText(Locale.ENGLISH)).build();
                issuable.addIssue(issue);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

