/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum EcmaScriptGrammar implements GrammarRuleKey
{
    EOF,
    EOS,
    EOS_NO_LB,
    IDENTIFIER_NAME,
    CONDITION,
    LITERAL,
    NULL_LITERAL,
    BOOLEAN_LITERAL,
    STRING_LITERAL,
    TEMPLATE_LITERAL,
    SUBSTITUTION_TEMPLATE,
    NO_SUBSTITUTION_TEMPLATE,
    TEMPLATE_SUBSTITUTION_TAIL,
    TEMPLATE_HEAD,
    TEMPLATE_SPANS,
    TEMPLATE_TAIL,
    TEMPLATE_MIDDLE_LIST,
    TEMPLATE_MIDDLE,
    TEMPLATE_CHARACTER,
    TEMPLATE_CHARACTERS,
    LINE_CONTINUATION,
    BACKTICK,
    DOLLAR_SIGN,
    BACKSLASH,
    KEYWORD,
    LETTER_OR_DIGIT,
    SPACING,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    LINE_TERMINATOR_SEQUENCE,
    PRIMARY_EXPRESSION,
    ARRAY_LITERAL,
    OBJECT_LITERAL,
    COVER_INITIALIZED_NAME,
    PROPERTY_DEFINITION,
    PAIR_PROPERTY,
    PROPERTY_NAME,
    MEMBER_EXPRESSION,
    SUPER_MEMBER_EXPRESSION,
    NEW_MEMBER_EXPRESSION,
    NEW_EXPRESSION,
    CALL_EXPRESSION,
    SIMPLE_CALL_EXPRESSION,
    ARGUMENTS,
    ARGUMENTS_LIST,
    LEFT_HAND_SIDE_EXPRESSION,
    POSTFIX_EXPRESSION,
    UNARY_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    ADDITIVE_EXPRESSION,
    SHIFT_EXPRESSION,
    RELATIONAL_EXPRESSION,
    RELATIONAL_EXPRESSION_NO_IN,
    EQUALITY_EXPRESSION,
    EQUALITY_EXPRESSION_NO_IN,
    BITWISE_AND_EXPRESSION,
    BITWISE_AND_EXPRESSION_NO_IN,
    BITWISE_XOR_EXPRESSION,
    BITWISE_XOR_EXPRESSION_NO_IN,
    BITWISE_OR_EXPRESSION,
    BITWISE_OR_EXPRESSION_NO_IN,
    LOGICAL_AND_EXPRESSION,
    LOGICAL_AND_EXPRESSION_NO_IN,
    LOGICAL_OR_EXPRESSION,
    LOGICAL_OR_EXPRESSION_NO_IN,
    CONDITIONAL_EXPRESSION,
    CONDITIONAL_EXPRESSION_NO_IN,
    ASSIGNMENT_EXPRESSION,
    ES6_ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_EXPRESSION_NO_IN,
    ES6_ASSIGNMENT_EXPRESSION_NO_IN,
    ASSIGNMENT_OPERATOR,
    EXPRESSION,
    EXPRESSION_NO_IN,
    ARROW_FUNCTION,
    ARROW_FUNCTION_NO_IN,
    ARROW_PARAMETERS,
    CONCISE_BODY,
    CONCISE_BODY_NO_IN,
    COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST,
    GENERATOR_EXPRESSION,
    CLASS_EXPRESSION,
    YIELD_EXPRESSION,
    YIELD_EXPRESSION_NO_IN,
    GENERATOR_COMPREHENSION,
    COMPREHENSION,
    COMPREHENSION_TAIL,
    COMPREHENSION_FOR,
    COMPREHENSION_IF,
    ARRAY_COMPREHENSION,
    ARRAY_INITIALIZER,
    ARRAY_INITIALIZER_ELEMENT,
    SPREAD_ELEMENT,
    ELISION,
    ELEMENT_LIST,
    BRACKET_EXPRESSION,
    OBJECT_PROPERTY_ACCESS,
    BINDING_REST_ELEMENT,
    SINGLE_NAME_BINDING,
    BINDING_ELEMENT,
    BINDING_PROPERTY,
    BINDING_ELISION_ELEMENT,
    BINDING_ELEMENT_LIST,
    BINDING_PROPERTY_LIST,
    ARRAY_BINDING_PATTERN,
    OBJECT_BINDING_PATTERN,
    BINDING_PATTERN,
    STATEMENT,
    BLOCK,
    STATEMENT_LIST,
    VARIABLE_STATEMENT,
    VARIABLE_DECLARATION_LIST,
    VARIABLE_DECLARATION_LIST_NO_IN,
    VARIABLE_DECLARATION,
    VARIABLE_DECLARATION_NO_IN,
    INITIALISER,
    INITIALISER_NO_IN,
    EMPTY_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    ELSE_CLAUSE,
    ITERATION_STATEMENT,
    DO_WHILE_STATEMENT,
    WHILE_STATEMENT,
    FOR_IN_STATEMENT,
    FOR_OF_STATEMENT,
    FOR_STATEMENT,
    OF,
    FOR_DECLARATION,
    FOR_BINDING,
    CONTINUE_STATEMENT,
    BREAK_STATEMENT,
    RETURN_STATEMENT,
    WITH_STATEMENT,
    SWITCH_STATEMENT,
    CASE_BLOCK,
    CASE_CLAUSES,
    CASE_CLAUSE,
    DEFAULT_CLAUSE,
    LABELLED_STATEMENT,
    THROW_STATEMENT,
    TRY_STATEMENT,
    CATCH,
    CATCH_PARAMETER,
    FINALLY,
    DEBUGGER_STATEMENT,
    DECLARATION,
    FUNCTION_DECLARATION,
    FUNCTION_EXPRESSION,
    FORMAL_PARAMETER_LIST,
    FORMAL_PARAMETER,
    REST_PARAMETER,
    FUNCTION_BODY,
    LEXICAL_DECLARATION,
    LEXICAL_DECLARATION_NO_IN,
    LET,
    LET_OR_CONST,
    BINDING_LIST,
    BINDING_LIST_NO_IN,
    LEXICAL_BINDING,
    LEXICAL_BINDING_NO_IN,
    BINDING_IDENTIFIER_INITIALISER,
    BINDING_IDENTIFIER_INITIALISER_NO_IN,
    BINDING_PATTERN_INITIALISER,
    BINDING_PATTERN_INITIALISER_NO_IN,
    BINDING_IDENTIFIER,
    IDENTIFIER_REFERENCE,
    COMPUTED_PROPERTY_NAME,
    LITERAL_PROPERTY_NAME,
    GENERATOR_METHOD,
    CLASS_DECLARATION,
    CLASS_TAIL,
    CLASS_HERITAGE,
    CLASS_BODY,
    CLASS_ELEMENT,
    STATIC_METHOD_DEFINITION,
    STATIC,
    METHOD_DEFINITION,
    METHOD,
    GETTER_METHOD,
    GET,
    SETTER_METHOD,
    PROPERTY_SET_PARAMETER_LIST,
    SET,
    MODULE_WORD,
    MODULE,
    MODULE_BODY,
    MODULE_ITEM,
    IMPORT_DECLARATION,
    EXPORT_DECLARATION,
    IMPORT_CLAUSE,
    FROM_CLAUSE,
    MODULE_IMPORT,
    NAMED_IMPORTS,
    IMPORTS_LIST,
    IMPORT_SPECIFIER,
    IMPORT_FROM,
    SIMPLE_IMPORT,
    FROM,
    AS,
    EXPORT_LIST_CLAUSE,
    EXPORT_ALL_CLAUSE,
    EXPORT_DEFAULT_CLAUSE,
    EXPORT_CLAUSE,
    EXPORT_LIST,
    EXPORT_SPECIFIER,
    GENERATOR_DECLARATION,
    SCRIPT,
    SCRIPT_BODY,
    SHEBANG;

    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return EcmaScriptGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule(IDENTIFIER_NAME).is(SPACING, b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+"));
        b.rule(LITERAL).is(b.firstOf(NULL_LITERAL, BOOLEAN_LITERAL, EcmaScriptTokenType.NUMERIC_LITERAL, STRING_LITERAL, EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL));
        b.rule(NULL_LITERAL).is(EcmaScriptKeyword.NULL);
        b.rule(BOOLEAN_LITERAL).is(b.firstOf(EcmaScriptKeyword.TRUE, EcmaScriptKeyword.FALSE));
        EcmaScriptGrammar.lexical(b);
        EcmaScriptGrammar.expressions(b);
        EcmaScriptGrammar.statements(b);
        EcmaScriptGrammar.declarations(b);
        EcmaScriptGrammar.programs(b);
        b.setRootRule(SCRIPT);
        return b;
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule(SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")))).skip();
        b.rule(SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule(NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:/\\*[\\s\\S]*?\\*/|[\\n\\r\\u2028\\u2029])"))).skip();
        b.rule(LINE_TERMINATOR_SEQUENCE).is(b.skippedTrivia(b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"))).skip();
        b.rule(EOS).is(b.firstOf(b.sequence(SPACING, EcmaScriptPunctuator.SEMI), b.sequence(SPACING_NO_LB, LINE_TERMINATOR_SEQUENCE), b.sequence(SPACING_NO_LB, b.next("}")), b.sequence(SPACING, b.endOfInput())));
        b.rule(EOS_NO_LB).is(b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptPunctuator.SEMI), b.sequence(SPACING_NO_LB, LINE_TERMINATOR_SEQUENCE), b.sequence(SPACING_NO_LB, b.next("}")), b.sequence(SPACING_NO_LB, b.endOfInput())));
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(EcmaScriptTokenType.IDENTIFIER).is(SPACING, b.nextNot(KEYWORD), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+"));
        b.rule(EcmaScriptTokenType.NUMERIC_LITERAL).is(SPACING, b.regexp("(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)"));
        b.rule(STRING_LITERAL).is(SPACING, b.token(GenericTokenType.LITERAL, b.regexp("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')")));
        b.rule(EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL).is(SPACING, b.regexp("\\/(?![*/])(?:[^\\\\\\[/&&[^\\r\\n\\u2028\\u2029]]|\\[(?:[^\\]\\\\&&[^\\r\\n\\u2028\\u2029]]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+"));
        b.rule(TEMPLATE_CHARACTERS).is(b.oneOrMore(TEMPLATE_CHARACTER));
        b.rule(TEMPLATE_CHARACTER).is(b.firstOf(b.sequence(DOLLAR_SIGN, b.nextNot(EcmaScriptPunctuator.LCURLYBRACE)), b.sequence(BACKSLASH, "\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}"), LINE_CONTINUATION, LINE_TERMINATOR_SEQUENCE, b.regexp("[^`\\$\\n\\r\\u2028\\u2029]")));
        b.rule(LINE_CONTINUATION).is(BACKSLASH, LINE_TERMINATOR_SEQUENCE);
        b.rule(BACKSLASH).is(EcmaScriptGrammar.character(b, "\\"));
        b.rule(BACKTICK).is(EcmaScriptGrammar.character(b, "`"));
        b.rule(DOLLAR_SIGN).is(EcmaScriptGrammar.character(b, "$"));
        EcmaScriptGrammar.punctuators(b);
        EcmaScriptGrammar.keywords(b);
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LCURLYBRACE, "{");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RCURLYBRACE, "}");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LPARENTHESIS, "(");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RPARENTHESIS, ")");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LBRACKET, "[");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RBRACKET, "]");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOUBLEARROW, "=>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOT, ".");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ELLIPSIS, "...");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SEMI, ";");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COMMA, ",");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LT, "<", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GT, ">", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LE, "<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GE, ">=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL, "==", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL, "!=", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL2, "===");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL2, "!==");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS, "+", b.nextNot(b.firstOf("+", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS, "-", b.nextNot(b.firstOf("-", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR, "*", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD, "%", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV, "/", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.INC, "++");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DEC, "--");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL, "<<", b.nextNot(b.firstOf("<", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR, ">>", b.nextNot(b.firstOf(">", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR2, ">>>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND, "&", b.nextNot("&", "="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR, "|", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR, "^", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.BANG, "!", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.TILDA, "~");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ANDAND, "&&");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OROR, "||");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.QUERY, "?");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COLON, ":");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQU, "=", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS_EQU, "+=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS_EQU, "-=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV_EQU, "/=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR_EQU, "*=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD_EQU, "%=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL_EQU, "<<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU, ">>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU2, ">>>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND_EQU, "&=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR_EQU, "|=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR_EQU, "^=");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule(LETTER_OR_DIGIT).is(b.regexp("\\p{javaJavaIdentifierPart}"));
        Object[] rest = new Object[EcmaScriptKeyword.values().length - 2];
        for (int i = 0; i < EcmaScriptKeyword.values().length; ++i) {
            EcmaScriptKeyword tokenType = EcmaScriptKeyword.values()[i];
            b.rule(tokenType).is(SPACING, tokenType.getValue(), b.nextNot(LETTER_OR_DIGIT));
            if (i <= 1) continue;
            rest[i - 2] = tokenType.getValue();
        }
        b.rule(KEYWORD).is(b.firstOf(EcmaScriptKeyword.keywordValues()[0], EcmaScriptKeyword.keywordValues()[1], rest), b.nextNot(LETTER_OR_DIGIT));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule(tokenType).is(SPACING, value);
            return;
        }
        throw new IllegalStateException(value);
    }

    private static Object word(LexerlessGrammarBuilder b, String value) {
        return b.sequence(SPACING, b.token(GenericTokenType.IDENTIFIER, value), b.nextNot(LETTER_OR_DIGIT));
    }

    private static Object character(LexerlessGrammarBuilder b, String value) {
        return b.sequence(SPACING, value);
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule(tokenType).is(SPACING, value, element);
            return;
        }
        throw new IllegalStateException(value);
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule(PRIMARY_EXPRESSION).is(b.firstOf(EcmaScriptKeyword.THIS, EcmaScriptTokenType.IDENTIFIER, LITERAL, ARRAY_INITIALIZER, OBJECT_LITERAL, FUNCTION_EXPRESSION, COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST, EcmaScriptGrammar.ecmascript6(CLASS_EXPRESSION), EcmaScriptGrammar.ecmascript6(GENERATOR_EXPRESSION), EcmaScriptGrammar.ecmascript6(GENERATOR_COMPREHENSION), EcmaScriptGrammar.ecmascript6(TEMPLATE_LITERAL)));
        b.rule(TEMPLATE_LITERAL).is(b.firstOf(NO_SUBSTITUTION_TEMPLATE, SUBSTITUTION_TEMPLATE));
        b.rule(NO_SUBSTITUTION_TEMPLATE).is(BACKTICK, b.optional(TEMPLATE_CHARACTERS), BACKTICK);
        b.rule(SUBSTITUTION_TEMPLATE).is(TEMPLATE_HEAD, EXPRESSION, b.optional(TEMPLATE_MIDDLE_LIST), TEMPLATE_TAIL);
        b.rule(TEMPLATE_HEAD).is(BACKTICK, b.optional(TEMPLATE_CHARACTERS), DOLLAR_SIGN, EcmaScriptPunctuator.LCURLYBRACE);
        b.rule(TEMPLATE_MIDDLE_LIST).is(b.oneOrMore(TEMPLATE_MIDDLE, EXPRESSION));
        b.rule(TEMPLATE_MIDDLE).is(EcmaScriptPunctuator.RCURLYBRACE, b.optional(TEMPLATE_CHARACTERS), DOLLAR_SIGN, EcmaScriptPunctuator.LCURLYBRACE);
        b.rule(TEMPLATE_TAIL).is(EcmaScriptPunctuator.RCURLYBRACE, b.optional(TEMPLATE_CHARACTERS), BACKTICK);
        b.rule(GENERATOR_COMPREHENSION).is(EcmaScriptPunctuator.LPARENTHESIS, COMPREHENSION, EcmaScriptPunctuator.RPARENTHESIS);
        b.rule(COMPREHENSION).is(COMPREHENSION_FOR, COMPREHENSION_TAIL);
        b.rule(COMPREHENSION_TAIL).is(b.zeroOrMore(b.firstOf(COMPREHENSION_FOR, COMPREHENSION_IF)), ASSIGNMENT_EXPRESSION);
        b.rule(COMPREHENSION_FOR).is(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, FOR_BINDING, OF, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS);
        b.rule(COMPREHENSION_IF).is(EcmaScriptKeyword.IF, EcmaScriptPunctuator.LPARENTHESIS, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS);
        b.rule(FOR_BINDING).is(b.firstOf(BINDING_IDENTIFIER, BINDING_PATTERN));
        b.rule(BINDING_PATTERN).is(b.firstOf(OBJECT_BINDING_PATTERN, ARRAY_BINDING_PATTERN));
        b.rule(OBJECT_BINDING_PATTERN).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(BINDING_PROPERTY_LIST, b.optional(EcmaScriptPunctuator.COMMA)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(BINDING_PROPERTY_LIST).is(BINDING_PROPERTY, b.zeroOrMore(EcmaScriptPunctuator.COMMA, BINDING_PROPERTY));
        b.rule(BINDING_PROPERTY).is(b.firstOf(b.sequence(PROPERTY_NAME, EcmaScriptPunctuator.COLON, BINDING_ELEMENT), SINGLE_NAME_BINDING));
        b.rule(ARRAY_BINDING_PATTERN).is(EcmaScriptPunctuator.LBRACKET, b.optional(b.firstOf(b.sequence(BINDING_ELEMENT_LIST, b.optional(EcmaScriptPunctuator.COMMA, b.optional(ELISION), b.optional(BINDING_REST_ELEMENT))), b.sequence(b.optional(ELISION), b.optional(BINDING_REST_ELEMENT)))), EcmaScriptPunctuator.RBRACKET);
        b.rule(BINDING_ELEMENT_LIST).is(BINDING_ELISION_ELEMENT, b.zeroOrMore(EcmaScriptPunctuator.COMMA, BINDING_ELISION_ELEMENT));
        b.rule(BINDING_ELISION_ELEMENT).is(b.optional(ELISION), BINDING_ELEMENT);
        b.rule(BINDING_ELEMENT).is(b.firstOf(SINGLE_NAME_BINDING, b.sequence(BINDING_PATTERN, b.optional(INITIALISER))));
        b.rule(SINGLE_NAME_BINDING).is(BINDING_IDENTIFIER, b.optional(INITIALISER));
        b.rule(BINDING_REST_ELEMENT).is(EcmaScriptPunctuator.ELLIPSIS, BINDING_IDENTIFIER);
        b.rule(COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST).is(EcmaScriptPunctuator.LPARENTHESIS, b.optional(b.firstOf(REST_PARAMETER, b.sequence(EXPRESSION, b.optional(EcmaScriptPunctuator.COMMA, REST_PARAMETER)))), EcmaScriptPunctuator.RPARENTHESIS);
        b.rule(CLASS_EXPRESSION).is(EcmaScriptKeyword.CLASS, b.optional(BINDING_IDENTIFIER), CLASS_TAIL);
        b.rule(GENERATOR_EXPRESSION).is(EcmaScriptKeyword.FUNCTION, EcmaScriptPunctuator.STAR, b.optional(BINDING_IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(ARRAY_INITIALIZER).is(b.firstOf(ARRAY_LITERAL, EcmaScriptGrammar.ecmascript6(ARRAY_COMPREHENSION)));
        b.rule(ARRAY_LITERAL).is(EcmaScriptPunctuator.LBRACKET, b.optional(b.firstOf(b.sequence(ELEMENT_LIST, b.optional(EcmaScriptPunctuator.COMMA, b.optional(ELISION))), ELISION)), EcmaScriptPunctuator.RBRACKET);
        b.rule(ELEMENT_LIST).is(b.optional(ELISION), ARRAY_INITIALIZER_ELEMENT, b.zeroOrMore(EcmaScriptPunctuator.COMMA, b.optional(ELISION), ARRAY_INITIALIZER_ELEMENT));
        b.rule(ARRAY_INITIALIZER_ELEMENT).is(b.firstOf(SPREAD_ELEMENT, ASSIGNMENT_EXPRESSION));
        b.rule(ELISION).is(b.oneOrMore(EcmaScriptPunctuator.COMMA));
        b.rule(SPREAD_ELEMENT).is(EcmaScriptPunctuator.ELLIPSIS, ASSIGNMENT_EXPRESSION);
        b.rule(ARRAY_COMPREHENSION).is(EcmaScriptPunctuator.LBRACKET, COMPREHENSION, EcmaScriptPunctuator.RBRACKET);
        b.rule(OBJECT_LITERAL).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(PROPERTY_DEFINITION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, PROPERTY_DEFINITION), b.optional(EcmaScriptPunctuator.COMMA)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(PROPERTY_DEFINITION).is(b.firstOf(PAIR_PROPERTY, METHOD_DEFINITION, EcmaScriptGrammar.ecmascript6(COVER_INITIALIZED_NAME)));
        b.rule(COVER_INITIALIZED_NAME).is(IDENTIFIER_REFERENCE, b.optional(INITIALISER));
        b.rule(PAIR_PROPERTY).is(PROPERTY_NAME, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION);
        b.rule(MEMBER_EXPRESSION).is(b.firstOf(EcmaScriptGrammar.ecmascript6(SUPER_MEMBER_EXPRESSION), NEW_MEMBER_EXPRESSION, PRIMARY_EXPRESSION), b.zeroOrMore(b.firstOf(BRACKET_EXPRESSION, OBJECT_PROPERTY_ACCESS, EcmaScriptGrammar.ecmascript6(TEMPLATE_LITERAL))));
        b.rule(SUPER_MEMBER_EXPRESSION).is(b.sequence(EcmaScriptKeyword.SUPER, b.firstOf(BRACKET_EXPRESSION, OBJECT_PROPERTY_ACCESS)));
        b.rule(NEW_MEMBER_EXPRESSION).is(b.sequence(EcmaScriptKeyword.NEW, b.firstOf(EcmaScriptGrammar.ecmascript6(EcmaScriptKeyword.SUPER), MEMBER_EXPRESSION), ARGUMENTS));
        b.rule(NEW_EXPRESSION).is(b.firstOf(MEMBER_EXPRESSION, EcmaScriptGrammar.ecmascript6(b.sequence(EcmaScriptKeyword.NEW, EcmaScriptKeyword.SUPER)), b.sequence(EcmaScriptKeyword.NEW, NEW_EXPRESSION)));
        b.rule(CALL_EXPRESSION).is(b.firstOf(SIMPLE_CALL_EXPRESSION, EcmaScriptGrammar.ecmascript6(TEMPLATE_LITERAL)), b.zeroOrMore(b.firstOf(ARGUMENTS, BRACKET_EXPRESSION, OBJECT_PROPERTY_ACCESS)));
        b.rule(BRACKET_EXPRESSION).is(EcmaScriptPunctuator.LBRACKET, EXPRESSION, EcmaScriptPunctuator.RBRACKET);
        b.rule(OBJECT_PROPERTY_ACCESS).is(EcmaScriptPunctuator.DOT, IDENTIFIER_NAME);
        b.rule(SIMPLE_CALL_EXPRESSION).is(b.firstOf(MEMBER_EXPRESSION, EcmaScriptGrammar.ecmascript6(EcmaScriptKeyword.SUPER)), ARGUMENTS);
        b.rule(ARGUMENTS).is(EcmaScriptPunctuator.LPARENTHESIS, b.optional(ARGUMENTS_LIST), EcmaScriptPunctuator.RPARENTHESIS);
        b.rule(ARGUMENTS_LIST).is(b.optional(EcmaScriptPunctuator.ELLIPSIS), ASSIGNMENT_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, b.optional(EcmaScriptPunctuator.ELLIPSIS), ASSIGNMENT_EXPRESSION));
        b.rule(LEFT_HAND_SIDE_EXPRESSION).is(b.firstOf(CALL_EXPRESSION, NEW_EXPRESSION));
        b.rule(POSTFIX_EXPRESSION).is(LEFT_HAND_SIDE_EXPRESSION, b.optional(SPACING_NO_LB, NEXT_NOT_LB, b.firstOf(EcmaScriptPunctuator.INC, EcmaScriptPunctuator.DEC)));
        b.rule(UNARY_EXPRESSION).is(b.firstOf(POSTFIX_EXPRESSION, b.sequence(EcmaScriptKeyword.DELETE, UNARY_EXPRESSION), b.sequence(EcmaScriptKeyword.VOID, UNARY_EXPRESSION), b.sequence(EcmaScriptKeyword.TYPEOF, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.INC, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.DEC, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.PLUS, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.MINUS, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.TILDA, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.BANG, UNARY_EXPRESSION)));
        b.rule(MULTIPLICATIVE_EXPRESSION).is(UNARY_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.STAR, EcmaScriptPunctuator.DIV, EcmaScriptPunctuator.MOD), UNARY_EXPRESSION)).skipIfOneChild();
        b.rule(ADDITIVE_EXPRESSION).is(MULTIPLICATIVE_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.PLUS, EcmaScriptPunctuator.MINUS), MULTIPLICATIVE_EXPRESSION)).skipIfOneChild();
        b.rule(SHIFT_EXPRESSION).is(ADDITIVE_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.SL, EcmaScriptPunctuator.SR, EcmaScriptPunctuator.SR2), ADDITIVE_EXPRESSION)).skipIfOneChild();
        b.rule(RELATIONAL_EXPRESSION).is(SHIFT_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.LT, EcmaScriptPunctuator.GT, EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF, EcmaScriptKeyword.IN), SHIFT_EXPRESSION)).skipIfOneChild();
        b.rule(RELATIONAL_EXPRESSION_NO_IN).is(SHIFT_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.LT, EcmaScriptPunctuator.GT, EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF), SHIFT_EXPRESSION)).skipIfOneChild();
        b.rule(EQUALITY_EXPRESSION).is(RELATIONAL_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2), RELATIONAL_EXPRESSION)).skipIfOneChild();
        b.rule(EQUALITY_EXPRESSION_NO_IN).is(RELATIONAL_EXPRESSION_NO_IN, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2), RELATIONAL_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(BITWISE_AND_EXPRESSION).is(EQUALITY_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.AND, EQUALITY_EXPRESSION)).skipIfOneChild();
        b.rule(BITWISE_AND_EXPRESSION_NO_IN).is(EQUALITY_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.AND, EQUALITY_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(BITWISE_XOR_EXPRESSION).is(BITWISE_AND_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.XOR, BITWISE_AND_EXPRESSION)).skipIfOneChild();
        b.rule(BITWISE_XOR_EXPRESSION_NO_IN).is(BITWISE_AND_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.XOR, BITWISE_AND_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(BITWISE_OR_EXPRESSION).is(BITWISE_XOR_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.OR, BITWISE_XOR_EXPRESSION)).skipIfOneChild();
        b.rule(BITWISE_OR_EXPRESSION_NO_IN).is(BITWISE_XOR_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.OR, BITWISE_XOR_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_AND_EXPRESSION).is(BITWISE_OR_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.ANDAND, BITWISE_OR_EXPRESSION)).skipIfOneChild();
        b.rule(LOGICAL_AND_EXPRESSION_NO_IN).is(BITWISE_OR_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.ANDAND, BITWISE_OR_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_OR_EXPRESSION).is(LOGICAL_AND_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.OROR, LOGICAL_AND_EXPRESSION)).skipIfOneChild();
        b.rule(LOGICAL_OR_EXPRESSION_NO_IN).is(LOGICAL_AND_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.OROR, LOGICAL_AND_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(CONDITIONAL_EXPRESSION).is(LOGICAL_OR_EXPRESSION, b.optional(EcmaScriptPunctuator.QUERY, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION)).skipIfOneChild();
        b.rule(CONDITIONAL_EXPRESSION_NO_IN).is(LOGICAL_OR_EXPRESSION_NO_IN, b.optional(EcmaScriptPunctuator.QUERY, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(ES6_ASSIGNMENT_EXPRESSION).is(b.firstOf(YIELD_EXPRESSION, ARROW_FUNCTION));
        b.rule(ES6_ASSIGNMENT_EXPRESSION_NO_IN).is(b.firstOf(YIELD_EXPRESSION_NO_IN, ARROW_FUNCTION_NO_IN));
        b.rule(ASSIGNMENT_EXPRESSION).is(b.firstOf(b.sequence(LEFT_HAND_SIDE_EXPRESSION, ASSIGNMENT_OPERATOR, ASSIGNMENT_EXPRESSION), b.sequence(CONDITIONAL_EXPRESSION, b.nextNot(b.regexp("(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]|//[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)*+"), "=>")), EcmaScriptGrammar.ecmascript6(ES6_ASSIGNMENT_EXPRESSION))).skipIfOneChild();
        b.rule(ASSIGNMENT_EXPRESSION_NO_IN).is(b.firstOf(b.sequence(LEFT_HAND_SIDE_EXPRESSION, ASSIGNMENT_OPERATOR, ASSIGNMENT_EXPRESSION_NO_IN), EcmaScriptGrammar.ecmascript6(ES6_ASSIGNMENT_EXPRESSION_NO_IN), CONDITIONAL_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(ASSIGNMENT_OPERATOR).is(b.firstOf(EcmaScriptPunctuator.EQU, EcmaScriptPunctuator.STAR_EQU, EcmaScriptPunctuator.DIV_EQU, EcmaScriptPunctuator.MOD_EQU, EcmaScriptPunctuator.PLUS_EQU, EcmaScriptPunctuator.MINUS_EQU, EcmaScriptPunctuator.SL_EQU, EcmaScriptPunctuator.SR_EQU, EcmaScriptPunctuator.SR_EQU2, EcmaScriptPunctuator.AND_EQU, EcmaScriptPunctuator.XOR_EQU, EcmaScriptPunctuator.OR_EQU)).skip();
        b.rule(YIELD_EXPRESSION).is(EcmaScriptKeyword.YIELD, b.optional(SPACING_NO_LB, NEXT_NOT_LB, b.optional(EcmaScriptPunctuator.STAR), ASSIGNMENT_EXPRESSION));
        b.rule(YIELD_EXPRESSION_NO_IN).is(EcmaScriptKeyword.YIELD, b.optional(SPACING_NO_LB, NEXT_NOT_LB, b.optional(EcmaScriptPunctuator.STAR), ASSIGNMENT_EXPRESSION_NO_IN));
        b.rule(ARROW_FUNCTION).is(ARROW_PARAMETERS, SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptPunctuator.DOUBLEARROW, CONCISE_BODY);
        b.rule(ARROW_FUNCTION_NO_IN).is(ARROW_PARAMETERS, SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptPunctuator.DOUBLEARROW, CONCISE_BODY_NO_IN);
        b.rule(ARROW_PARAMETERS).is(b.firstOf(BINDING_IDENTIFIER, COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST));
        b.rule(CONCISE_BODY).is(b.firstOf(b.sequence(EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE), b.sequence(b.nextNot(EcmaScriptPunctuator.LCURLYBRACE), ASSIGNMENT_EXPRESSION)));
        b.rule(CONCISE_BODY_NO_IN).is(b.firstOf(b.sequence(EcmaScriptPunctuator.LPARENTHESIS, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE), b.sequence(b.nextNot(EcmaScriptPunctuator.LCURLYBRACE), ASSIGNMENT_EXPRESSION_NO_IN)));
        b.rule(EXPRESSION).is(ASSIGNMENT_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, ASSIGNMENT_EXPRESSION));
        b.rule(EXPRESSION_NO_IN).is(ASSIGNMENT_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.COMMA, ASSIGNMENT_EXPRESSION_NO_IN));
    }

    private static void statements(LexerlessGrammarBuilder b) {
        b.rule(STATEMENT).is(b.firstOf(BLOCK, VARIABLE_STATEMENT, EMPTY_STATEMENT, LABELLED_STATEMENT, EXPRESSION_STATEMENT, IF_STATEMENT, ITERATION_STATEMENT, CONTINUE_STATEMENT, BREAK_STATEMENT, RETURN_STATEMENT, WITH_STATEMENT, SWITCH_STATEMENT, THROW_STATEMENT, TRY_STATEMENT, DEBUGGER_STATEMENT));
        b.rule(BLOCK).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(STATEMENT_LIST), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(STATEMENT_LIST).is(b.oneOrMore(b.firstOf(EcmaScriptGrammar.ecmascript6(DECLARATION), STATEMENT)));
        b.rule(VARIABLE_STATEMENT).is(EcmaScriptKeyword.VAR, VARIABLE_DECLARATION_LIST, EOS);
        b.rule(VARIABLE_DECLARATION_LIST).is(VARIABLE_DECLARATION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, VARIABLE_DECLARATION));
        b.rule(VARIABLE_DECLARATION_LIST_NO_IN).is(VARIABLE_DECLARATION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.COMMA, VARIABLE_DECLARATION_NO_IN));
        b.rule(VARIABLE_DECLARATION).is(b.firstOf(BINDING_IDENTIFIER_INITIALISER, BINDING_PATTERN_INITIALISER));
        b.rule(VARIABLE_DECLARATION_NO_IN).is(b.firstOf(BINDING_IDENTIFIER_INITIALISER_NO_IN, BINDING_PATTERN_INITIALISER_NO_IN));
        b.rule(INITIALISER).is(EcmaScriptPunctuator.EQU, ASSIGNMENT_EXPRESSION);
        b.rule(INITIALISER_NO_IN).is(EcmaScriptPunctuator.EQU, ASSIGNMENT_EXPRESSION_NO_IN);
        b.rule(EMPTY_STATEMENT).is(EcmaScriptPunctuator.SEMI);
        b.rule(EXPRESSION_STATEMENT).is(b.nextNot(b.firstOf(EcmaScriptPunctuator.LCURLYBRACE, EcmaScriptKeyword.FUNCTION)), EXPRESSION, EOS);
        b.rule(CONDITION).is(EXPRESSION);
        b.rule(IF_STATEMENT).is(EcmaScriptKeyword.IF, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT, b.optional(ELSE_CLAUSE));
        b.rule(ELSE_CLAUSE).is(EcmaScriptKeyword.ELSE, STATEMENT);
        b.rule(ITERATION_STATEMENT).is(b.firstOf(DO_WHILE_STATEMENT, WHILE_STATEMENT, FOR_IN_STATEMENT, EcmaScriptGrammar.ecmascript6(FOR_OF_STATEMENT), FOR_STATEMENT));
        b.rule(DO_WHILE_STATEMENT).is(EcmaScriptKeyword.DO, STATEMENT, EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, EOS);
        b.rule(WHILE_STATEMENT).is(EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(FOR_IN_STATEMENT).is(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence(EcmaScriptKeyword.VAR, b.firstOf(VARIABLE_DECLARATION_LIST_NO_IN, EcmaScriptGrammar.ecmascript6(FOR_BINDING))), b.sequence(EcmaScriptGrammar.ecmascript6(b.nextNot(LET, EcmaScriptPunctuator.LBRACKET)), LEFT_HAND_SIDE_EXPRESSION), EcmaScriptGrammar.ecmascript6(FOR_DECLARATION)), EcmaScriptKeyword.IN, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(FOR_OF_STATEMENT).is(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence(EcmaScriptKeyword.VAR, FOR_BINDING), b.sequence(b.nextNot(LET), LEFT_HAND_SIDE_EXPRESSION), FOR_DECLARATION), OF, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(FOR_DECLARATION).is(LET_OR_CONST, FOR_BINDING);
        b.rule(OF).is(EcmaScriptGrammar.word(b, "of"));
        b.rule(FOR_STATEMENT).is(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence(EcmaScriptKeyword.VAR, VARIABLE_DECLARATION_LIST_NO_IN), EcmaScriptGrammar.ecmascript6(b.sequence(LEXICAL_DECLARATION_NO_IN, b.optional(EXPRESSION_NO_IN))), b.optional(EcmaScriptGrammar.ecmascript6(b.nextNot(LET, EcmaScriptPunctuator.LBRACKET)), EXPRESSION_NO_IN)), EcmaScriptPunctuator.SEMI, b.optional(CONDITION), EcmaScriptPunctuator.SEMI, b.optional(EXPRESSION), EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(CONTINUE_STATEMENT).is(EcmaScriptKeyword.CONTINUE, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptTokenType.IDENTIFIER, EOS), EOS_NO_LB));
        b.rule(BREAK_STATEMENT).is(EcmaScriptKeyword.BREAK, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptTokenType.IDENTIFIER, EOS), EOS_NO_LB));
        b.rule(RETURN_STATEMENT).is(EcmaScriptKeyword.RETURN, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EXPRESSION, EOS), EOS_NO_LB));
        b.rule(WITH_STATEMENT).is(EcmaScriptKeyword.WITH, EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(SWITCH_STATEMENT).is(EcmaScriptKeyword.SWITCH, EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, CASE_BLOCK);
        b.rule(CASE_BLOCK).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(CASE_CLAUSES), b.optional(DEFAULT_CLAUSE, b.optional(CASE_CLAUSES)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(CASE_CLAUSES).is(b.oneOrMore(CASE_CLAUSE));
        b.rule(CASE_CLAUSE).is(EcmaScriptKeyword.CASE, EXPRESSION, EcmaScriptPunctuator.COLON, b.optional(STATEMENT_LIST));
        b.rule(DEFAULT_CLAUSE).is(EcmaScriptKeyword.DEFAULT, EcmaScriptPunctuator.COLON, b.optional(STATEMENT_LIST));
        b.rule(LABELLED_STATEMENT).is(EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.COLON, STATEMENT);
        b.rule(THROW_STATEMENT).is(EcmaScriptKeyword.THROW, SPACING_NO_LB, NEXT_NOT_LB, EXPRESSION, EOS);
        b.rule(TRY_STATEMENT).is(EcmaScriptKeyword.TRY, BLOCK, b.firstOf(b.sequence(CATCH, b.optional(FINALLY)), FINALLY));
        b.rule(CATCH).is(EcmaScriptKeyword.CATCH, EcmaScriptPunctuator.LPARENTHESIS, CATCH_PARAMETER, EcmaScriptPunctuator.RPARENTHESIS, BLOCK);
        b.rule(CATCH_PARAMETER).is(b.firstOf(BINDING_IDENTIFIER, BINDING_PATTERN));
        b.rule(FINALLY).is(EcmaScriptKeyword.FINALLY, BLOCK);
        b.rule(DEBUGGER_STATEMENT).is(EcmaScriptKeyword.DEBUGGER, EOS);
    }

    private static void declarations(LexerlessGrammarBuilder b) {
        b.rule(MODULE).is(MODULE_BODY);
        b.rule(MODULE_BODY).is(b.oneOrMore(MODULE_ITEM));
        b.rule(MODULE_ITEM).is(b.firstOf(IMPORT_DECLARATION, EXPORT_DECLARATION, DECLARATION, STATEMENT));
        b.rule(EXPORT_DECLARATION).is(EcmaScriptKeyword.EXPORT, b.firstOf(EXPORT_ALL_CLAUSE, EXPORT_LIST_CLAUSE, VARIABLE_STATEMENT, DECLARATION, EXPORT_DEFAULT_CLAUSE));
        b.rule(EXPORT_ALL_CLAUSE).is(EcmaScriptPunctuator.STAR, FROM_CLAUSE, EOS);
        b.rule(EXPORT_DEFAULT_CLAUSE).is(EcmaScriptKeyword.DEFAULT, ASSIGNMENT_EXPRESSION, EOS);
        b.rule(EXPORT_LIST_CLAUSE).is(EXPORT_CLAUSE, b.optional(FROM_CLAUSE), EOS);
        b.rule(EXPORT_CLAUSE).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(EXPORT_LIST, b.optional(EcmaScriptPunctuator.COMMA)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(EXPORT_LIST).is(EXPORT_SPECIFIER, b.zeroOrMore(EcmaScriptPunctuator.COMMA, EXPORT_SPECIFIER));
        b.rule(EXPORT_SPECIFIER).is(b.firstOf(IDENTIFIER_REFERENCE, IDENTIFIER_NAME), b.optional(AS, IDENTIFIER_NAME));
        b.rule(IMPORT_DECLARATION).is(b.firstOf(MODULE_IMPORT, SIMPLE_IMPORT, IMPORT_FROM));
        b.rule(MODULE_IMPORT).is(MODULE_WORD, SPACING_NO_LB, NEXT_NOT_LB, BINDING_IDENTIFIER, FROM_CLAUSE, EOS);
        b.rule(MODULE_WORD).is(EcmaScriptGrammar.word(b, "module"));
        b.rule(SIMPLE_IMPORT).is(EcmaScriptKeyword.IMPORT, STRING_LITERAL, EOS);
        b.rule(IMPORT_FROM).is(EcmaScriptKeyword.IMPORT, IMPORT_CLAUSE, FROM_CLAUSE, EOS);
        b.rule(FROM_CLAUSE).is(FROM, STRING_LITERAL);
        b.rule(FROM).is(EcmaScriptGrammar.word(b, "from"));
        b.rule(IMPORT_CLAUSE).is(b.firstOf(NAMED_IMPORTS, b.sequence(BINDING_IDENTIFIER, b.optional(EcmaScriptPunctuator.COMMA, NAMED_IMPORTS))));
        b.rule(NAMED_IMPORTS).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(IMPORTS_LIST, b.optional(EcmaScriptPunctuator.COMMA)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(IMPORTS_LIST).is(IMPORT_SPECIFIER, b.zeroOrMore(EcmaScriptPunctuator.COMMA, IMPORT_SPECIFIER));
        b.rule(IMPORT_SPECIFIER).is(b.optional(IDENTIFIER_NAME, AS), BINDING_IDENTIFIER);
        b.rule(AS).is(EcmaScriptGrammar.word(b, "as"));
        b.rule(DECLARATION).is(b.firstOf(FUNCTION_DECLARATION, EcmaScriptGrammar.ecmascript6(GENERATOR_DECLARATION), EcmaScriptGrammar.ecmascript6(CLASS_DECLARATION), EcmaScriptGrammar.ecmascript6(LEXICAL_DECLARATION)));
        b.rule(FUNCTION_DECLARATION).is(EcmaScriptKeyword.FUNCTION, EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(FUNCTION_EXPRESSION).is(EcmaScriptKeyword.FUNCTION, b.optional(EcmaScriptTokenType.IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(FORMAL_PARAMETER_LIST).is(b.firstOf(b.sequence(FORMAL_PARAMETER, b.zeroOrMore(EcmaScriptPunctuator.COMMA, FORMAL_PARAMETER), EcmaScriptGrammar.ecmascript6(b.optional(EcmaScriptPunctuator.COMMA, REST_PARAMETER))), EcmaScriptGrammar.ecmascript6(REST_PARAMETER)));
        b.rule(REST_PARAMETER).is(BINDING_REST_ELEMENT);
        b.rule(FORMAL_PARAMETER).is(BINDING_ELEMENT);
        b.rule(FUNCTION_BODY).is(b.optional(STATEMENT_LIST));
        b.rule(GENERATOR_DECLARATION).is(EcmaScriptKeyword.FUNCTION, EcmaScriptPunctuator.STAR, BINDING_IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(LEXICAL_DECLARATION).is(LET_OR_CONST, BINDING_LIST);
        b.rule(LEXICAL_DECLARATION_NO_IN).is(LET_OR_CONST, BINDING_LIST_NO_IN);
        b.rule(LET_OR_CONST).is(b.firstOf(LET, EcmaScriptKeyword.CONST));
        b.rule(LET).is(EcmaScriptGrammar.word(b, "let"));
        b.rule(BINDING_LIST).is(LEXICAL_BINDING, b.zeroOrMore(EcmaScriptPunctuator.COMMA, LEXICAL_BINDING));
        b.rule(BINDING_LIST_NO_IN).is(LEXICAL_BINDING_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.COMMA, LEXICAL_BINDING_NO_IN));
        b.rule(LEXICAL_BINDING).is(b.firstOf(BINDING_IDENTIFIER_INITIALISER, BINDING_PATTERN_INITIALISER));
        b.rule(LEXICAL_BINDING_NO_IN).is(b.firstOf(BINDING_IDENTIFIER_INITIALISER_NO_IN, BINDING_PATTERN_INITIALISER_NO_IN));
        b.rule(BINDING_IDENTIFIER_INITIALISER).is(BINDING_IDENTIFIER, b.optional(INITIALISER));
        b.rule(BINDING_IDENTIFIER_INITIALISER_NO_IN).is(BINDING_IDENTIFIER, b.optional(INITIALISER_NO_IN));
        b.rule(BINDING_PATTERN_INITIALISER).is(BINDING_PATTERN, INITIALISER);
        b.rule(BINDING_PATTERN_INITIALISER_NO_IN).is(BINDING_PATTERN, INITIALISER_NO_IN);
        b.rule(BINDING_IDENTIFIER).is(b.firstOf(EcmaScriptGrammar.ecmascript6(EcmaScriptKeyword.DEFAULT), EcmaScriptGrammar.ecmascript6(EcmaScriptKeyword.YIELD), EcmaScriptTokenType.IDENTIFIER));
        b.rule(IDENTIFIER_REFERENCE).is(b.firstOf(EcmaScriptKeyword.YIELD, EcmaScriptTokenType.IDENTIFIER));
        b.rule(CLASS_DECLARATION).is(EcmaScriptKeyword.CLASS, BINDING_IDENTIFIER, CLASS_TAIL);
        b.rule(CLASS_TAIL).is(b.optional(CLASS_HERITAGE), EcmaScriptPunctuator.LCURLYBRACE, b.optional(CLASS_BODY), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(CLASS_HERITAGE).is(EcmaScriptKeyword.EXTENDS, LEFT_HAND_SIDE_EXPRESSION);
        b.rule(CLASS_BODY).is(b.oneOrMore(CLASS_ELEMENT));
        b.rule(CLASS_ELEMENT).is(b.firstOf(STATIC_METHOD_DEFINITION, METHOD_DEFINITION, EcmaScriptPunctuator.SEMI));
        b.rule(STATIC_METHOD_DEFINITION).is(STATIC, METHOD_DEFINITION);
        b.rule(STATIC).is(EcmaScriptGrammar.word(b, "static"));
        b.rule(METHOD_DEFINITION).is(b.firstOf(EcmaScriptGrammar.ecmascript6(METHOD), EcmaScriptGrammar.ecmascript6(GENERATOR_METHOD), GETTER_METHOD, SETTER_METHOD));
        b.rule(METHOD).is(PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(SETTER_METHOD).is(b.sequence(SET, PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, PROPERTY_SET_PARAMETER_LIST, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE));
        b.rule(PROPERTY_SET_PARAMETER_LIST).is(FORMAL_PARAMETER);
        b.rule(SET).is(EcmaScriptGrammar.word(b, "set"));
        b.rule(GETTER_METHOD).is(b.sequence(GET, PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE));
        b.rule(GET).is(EcmaScriptGrammar.word(b, "get"));
        b.rule(GENERATOR_METHOD).is(EcmaScriptPunctuator.STAR, PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(PROPERTY_NAME).is(b.firstOf(LITERAL_PROPERTY_NAME, EcmaScriptGrammar.ecmascript6(COMPUTED_PROPERTY_NAME)));
        b.rule(LITERAL_PROPERTY_NAME).is(b.firstOf(IDENTIFIER_NAME, STRING_LITERAL, EcmaScriptTokenType.NUMERIC_LITERAL));
        b.rule(COMPUTED_PROPERTY_NAME).is(EcmaScriptPunctuator.LBRACKET, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RBRACKET);
    }

    private static void programs(LexerlessGrammarBuilder b) {
        b.rule(SCRIPT).is(b.optional(SHEBANG), b.optional(MODULE_BODY), SPACING, EOF);
        b.rule(SHEBANG).is("#!", b.regexp("[^\\n\\r]*+")).skip();
    }

    private static Object ecmascript6(Object object) {
        return object;
    }

    private EcmaScriptGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

