/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.SonarException;

public abstract class PythonReportSensor
implements Sensor {
    protected static final Logger LOG = LoggerFactory.getLogger(PythonReportSensor.class);
    protected Settings conf = null;
    protected ModuleFileSystem fileSystem;

    public PythonReportSensor(Settings conf, ModuleFileSystem fileSystem) {
        this.conf = conf;
        this.fileSystem = fileSystem;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"py"})).isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        try {
            List<File> reports = this.getReports(this.conf, this.fileSystem.baseDir().getPath(), this.reportPathKey(), this.defaultReportPath());
            for (File report : reports) {
                LOG.info("Processing report '{}'", (Object)report);
                this.processReport(project, context, report);
            }
        }
        catch (XMLStreamException e) {
            String msg = "Cannot feed the data into sonar, details: '" + e + "'";
            throw new SonarException(msg, (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected List<File> getReports(Settings conf, String baseDirPath, String reportPathPropertyKey, String defaultReportPath) {
        String reportPath = conf.getString(reportPathPropertyKey);
        if (reportPath == null) {
            reportPath = defaultReportPath;
        }
        LOG.debug("Using pattern '{}' to find reports", (Object)reportPath);
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includes = new String[]{reportPath};
        scanner.setIncludes(includes);
        scanner.setBasedir(new File(baseDirPath));
        scanner.scan();
        String[] relPaths = scanner.getIncludedFiles();
        ArrayList reports = Lists.newArrayList();
        for (String relPath : relPaths) {
            reports.add(new File(baseDirPath, relPath));
        }
        return reports;
    }

    protected void processReport(Project project, SensorContext context, File report) throws XMLStreamException {
    }

    protected void handleNoReportsCase(SensorContext context) {
    }

    protected String reportPathKey() {
        return "";
    }

    protected String defaultReportPath() {
        return "";
    }
}

