/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandExecutor;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.plugins.python.pylint.CommandStreamConsumer;

public class PylintArguments {
    private static final Pattern PYLINT_VERSION_PATTERN = Pattern.compile(".*pylint[^ ]* ([0-9\\.]+).*");
    private static final String[] ARGS_PYLINT_0_X = new String[]{"-i", "y", "-f", "parseable", "-r", "n"};
    private static final String[] ARGS_PYLINT_1_X = new String[]{"--msg-template", "{path}:{line}: [{msg_id}({symbol}), {obj}] {msg}", "-r", "n"};
    private final String[] arguments;

    public PylintArguments(Command command) {
        String pylintVersion = PylintArguments.pylintVersion(command);
        this.arguments = pylintVersion.startsWith("0") ? ARGS_PYLINT_0_X : ARGS_PYLINT_1_X;
    }

    private static String pylintVersion(Command command) {
        long timeout = 10000L;
        CommandStreamConsumer out = new CommandStreamConsumer();
        CommandStreamConsumer err = new CommandStreamConsumer();
        CommandExecutor.create().execute(command, (StreamConsumer)out, (StreamConsumer)err, timeout);
        Iterable outputLines = Iterables.concat(out.getData(), err.getData());
        for (String outLine : outputLines) {
            Matcher matcher = PYLINT_VERSION_PATTERN.matcher(outLine);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        String message = "Failed to determine pylint version with command: \"" + command.toCommandLine() + "\", received " + Iterables.size((Iterable)outputLines) + " line(s) of output:\n" + Joiner.on((char)'\n').join(outputLines);
        throw new IllegalArgumentException(message);
    }

    public String[] arguments() {
        return this.arguments;
    }
}

