/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import org.sonar.api.utils.SonarException;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractLineLengthCheck<G extends Grammar>
extends SquidCheck<G>
implements AstAndTokenVisitor {
    private int lastIncorrectLine;

    public abstract int getMaximumLineLength();

    @Override
    public void init() {
        if (this.getMaximumLineLength() <= 0) {
            throw new SonarException("The maximal line length must be set to a value greater than 0, but given: " + this.getMaximumLineLength());
        }
    }

    @Override
    public void visitFile(AstNode astNode) {
        this.lastIncorrectLine = -1;
    }

    @Override
    public void visitToken(Token token) {
        if (!token.isGeneratedCode() && this.lastIncorrectLine != token.getLine() && token.getColumn() + token.getValue().length() > this.getMaximumLineLength()) {
            this.lastIncorrectLine = token.getLine();
            this.getContext().createLineViolation((CodeCheck)this, "The line length is greater than {0,number,integer} authorized.", token.getLine(), this.getMaximumLineLength());
        }
    }
}

