/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.api.utils.SonarException;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractNestedIfCheck<G extends Grammar>
extends SquidCheck<G> {
    private int nestingLevel;

    public abstract int getMaximumNestingLevel();

    public abstract AstNodeType getIfRule();

    @Override
    public void visitFile(AstNode astNode) {
        this.nestingLevel = 0;
    }

    @Override
    public void init() {
        if (this.getMaximumNestingLevel() <= 0) {
            throw new SonarException("The maximal if nesting level must be set to a value greater than 0, but given: " + this.getMaximumNestingLevel());
        }
        this.subscribeTo(this.getIfRule());
    }

    @Override
    public void visitNode(AstNode astNode) {
        ++this.nestingLevel;
        if (this.nestingLevel == this.getMaximumNestingLevel() + 1) {
            this.getContext().createLineViolation((CodeCheck)this, "This if has a nesting level of {0}, which is higher than the maximum allowed {1}.", astNode, this.nestingLevel, this.getMaximumNestingLevel());
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        --this.nestingLevel;
    }
}

